// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.sdk.kotlin.services.sfn.model.StartExecutionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class StartExecutionOperationDeserializer: HttpDeserialize<StartExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartExecutionResponse {
        if (!response.status.isSuccess()) {
            throwStartExecutionError(context, response)
        }
        val builder = StartExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartExecutionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartExecutionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ExecutionAlreadyExists" -> ExecutionAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "ExecutionLimitExceeded" -> ExecutionLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedResponse)
        "InvalidExecutionInput" -> InvalidExecutionInputDeserializer().deserialize(context, wrappedResponse)
        "InvalidName" -> InvalidNameDeserializer().deserialize(context, wrappedResponse)
        "StateMachineDeleting" -> StateMachineDeletingDeserializer().deserialize(context, wrappedResponse)
        "StateMachineDoesNotExist" -> StateMachineDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartExecutionOperationBody(builder: StartExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionArn"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXECUTIONARN_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXECUTIONARN_DESCRIPTOR.index -> builder.executionArn = deserializeString()
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
