// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sfn.transform

import aws.sdk.kotlin.services.sfn.model.SfnException
import aws.sdk.kotlin.services.sfn.model.UpdateStateMachineResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateStateMachineOperationDeserializer: HttpDeserialize<UpdateStateMachineResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateStateMachineResponse {
        if (!response.status.isSuccess()) {
            throwUpdateStateMachineError(context, response)
        }
        val builder = UpdateStateMachineResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateStateMachineOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateStateMachineError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SfnException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArn" -> InvalidArnDeserializer().deserialize(context, wrappedResponse)
        "InvalidDefinition" -> InvalidDefinitionDeserializer().deserialize(context, wrappedResponse)
        "InvalidLoggingConfiguration" -> InvalidLoggingConfigurationDeserializer().deserialize(context, wrappedResponse)
        "InvalidTracingConfiguration" -> InvalidTracingConfigurationDeserializer().deserialize(context, wrappedResponse)
        "MissingRequiredParameter" -> MissingRequiredParameterDeserializer().deserialize(context, wrappedResponse)
        "StateMachineDeleting" -> StateMachineDeletingDeserializer().deserialize(context, wrappedResponse)
        "StateMachineDoesNotExist" -> StateMachineDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SfnException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateStateMachineOperationBody(builder: UpdateStateMachineResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val UPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateDate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(UPDATEDATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                UPDATEDATE_DESCRIPTOR.index -> builder.updateDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
