/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private volatile int count = 0;
    private transient Node head;
    private transient Node last;
    private final Object takeLock = new SerializableLock();
    private final Object putLock = new SerializableLock();

    private void signalNotEmpty() {
        Object object = this.takeLock;
        synchronized (object) {
            this.takeLock.notify();
        }
    }

    private void signalNotFull() {
        Object object = this.putLock;
        synchronized (object) {
            this.putLock.notify();
        }
    }

    private void insert(Object x) {
        this.last = this.last.next = new Node(x);
    }

    private Object extract() {
        Node first;
        this.head = first = this.head.next;
        Object x = first.item;
        first.item = null;
        return x;
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.last = this.head = new Node(null);
    }

    public LinkedBlockingQueue(Collection c) {
        this(Integer.MAX_VALUE);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            Object e = itr.next();
            this.add(e);
        }
    }

    public int size() {
        return this.count;
    }

    public int remainingCapacity() {
        return this.capacity - this.count;
    }

    public void put(Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int c = -1;
        Object object = this.putLock;
        synchronized (object) {
            try {
                while (this.count == this.capacity) {
                    this.putLock.wait();
                }
            }
            catch (InterruptedException ie) {
                this.putLock.notify();
                throw ie;
            }
            this.insert(e);
            LinkedBlockingQueue linkedBlockingQueue = this;
            synchronized (linkedBlockingQueue) {
                c = this.count++;
            }
            if (c + 1 < this.capacity) {
                this.putLock.notify();
            }
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
    }

    public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        int c = -1;
        Object object = this.putLock;
        synchronized (object) {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.count < this.capacity) {
                    this.insert(e);
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        c = this.count++;
                    }
                    if (c + 1 >= this.capacity) break;
                    this.putLock.notify();
                    break;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    TimeUnit.NANOSECONDS.timedWait(this.putLock, nanos);
                    nanos = deadline - Utils.nanoTime();
                }
                catch (InterruptedException ie) {
                    this.putLock.notify();
                    throw ie;
                }
            }
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    public boolean offer(Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.count == this.capacity) {
            return false;
        }
        int c = -1;
        Object object = this.putLock;
        synchronized (object) {
            if (this.count < this.capacity) {
                this.insert(e);
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    c = this.count++;
                }
                if (c + 1 < this.capacity) {
                    this.putLock.notify();
                }
            }
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    public Object take() throws InterruptedException {
        Object x;
        int c = -1;
        Object object = this.takeLock;
        synchronized (object) {
            try {
                while (this.count == 0) {
                    this.takeLock.wait();
                }
            }
            catch (InterruptedException ie) {
                this.takeLock.notify();
                throw ie;
            }
            x = this.extract();
            LinkedBlockingQueue linkedBlockingQueue = this;
            synchronized (linkedBlockingQueue) {
                c = this.count--;
            }
            if (c > 1) {
                this.takeLock.notify();
            }
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object x = null;
        int c = -1;
        long nanos = unit.toNanos(timeout);
        Object object = this.takeLock;
        synchronized (object) {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.count > 0) {
                    x = this.extract();
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        c = this.count--;
                    }
                    if (c <= 1) break;
                    this.takeLock.notify();
                    break;
                }
                if (nanos <= 0L) {
                    Object var11_9 = null;
                    return var11_9;
                }
                try {
                    TimeUnit.NANOSECONDS.timedWait(this.takeLock, nanos);
                    nanos = deadline - Utils.nanoTime();
                }
                catch (InterruptedException ie) {
                    this.takeLock.notify();
                    throw ie;
                }
            }
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    public Object poll() {
        if (this.count == 0) {
            return null;
        }
        Object x = null;
        int c = -1;
        Object object = this.takeLock;
        synchronized (object) {
            if (this.count > 0) {
                x = this.extract();
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    c = this.count--;
                }
                if (c > 1) {
                    this.takeLock.notify();
                }
            }
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    public Object peek() {
        if (this.count == 0) {
            return null;
        }
        Object object = this.takeLock;
        synchronized (object) {
            Node first = this.head.next;
            if (first == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Object object2 = first.item;
            return object2;
        }
    }

    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        boolean removed = false;
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                Node trail = this.head;
                Node p = this.head.next;
                while (p != null) {
                    if (o.equals(p.item)) {
                        removed = true;
                        break;
                    }
                    trail = p;
                    p = p.next;
                }
                if (removed) {
                    p.item = null;
                    trail.next = p.next;
                    if (this.last == p) {
                        this.last = trail;
                    }
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        if (this.count-- == this.capacity) {
                            this.putLock.notifyAll();
                        }
                    }
                }
            }
        }
        return removed;
    }

    public Object[] toArray() {
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                int size = this.count;
                Object[] a = new Object[size];
                int k = 0;
                Node p = this.head.next;
                while (p != null) {
                    a[k++] = p.item;
                    p = p.next;
                }
                Object[] objectArray = a;
                return objectArray;
            }
        }
    }

    public Object[] toArray(Object[] a) {
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                int size = this.count;
                if (a.length < size) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                int k = 0;
                Node p = this.head.next;
                while (p != null) {
                    a[k++] = p.item;
                    p = p.next;
                }
                if (a.length > k) {
                    a[k] = null;
                }
                Object[] objectArray = a;
                return objectArray;
            }
        }
    }

    public String toString() {
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                String string = super.toString();
                return string;
            }
        }
    }

    public void clear() {
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                int c;
                this.head.next = null;
                this.last = this.head;
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    c = this.count;
                    this.count = 0;
                }
                if (c == this.capacity) {
                    this.putLock.notifyAll();
                }
            }
        }
    }

    public int drainTo(Collection c) {
        Node first;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                int cold;
                first = this.head.next;
                this.head.next = null;
                this.last = this.head;
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    cold = this.count;
                    this.count = 0;
                }
                if (cold == this.capacity) {
                    this.putLock.notifyAll();
                }
            }
        }
        int n = 0;
        Node p = first;
        while (p != null) {
            c.add(p.item);
            p.item = null;
            ++n;
            p = p.next;
        }
        return n;
    }

    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                int n = 0;
                Node p = this.head.next;
                while (p != null && n < maxElements) {
                    c.add(p.item);
                    p.item = null;
                    p = p.next;
                    ++n;
                }
                if (n != 0) {
                    int cold;
                    this.head.next = p;
                    if (p == null) {
                        this.last = this.head;
                    }
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        cold = this.count;
                        this.count -= n;
                    }
                    if (cold == this.capacity) {
                        this.putLock.notifyAll();
                    }
                }
                int n2 = n;
                return n2;
            }
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.putLock;
        synchronized (object) {
            Object object2 = this.takeLock;
            synchronized (object2) {
                s.defaultWriteObject();
                Node p = this.head.next;
                while (p != null) {
                    s.writeObject(p.item);
                    p = p.next;
                }
                s.writeObject(null);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        LinkedBlockingQueue linkedBlockingQueue = this;
        synchronized (linkedBlockingQueue) {
            this.count = 0;
        }
        this.last = this.head = new Node(null);
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    private static class SerializableLock
    implements Serializable {
        private static final long serialVersionUID = -8856990691138858668L;

        private SerializableLock() {
        }
    }

    private class Itr
    implements Iterator {
        private Node current;
        private Node lastRet;
        private Object currentElement;

        Itr() {
            Object object = LinkedBlockingQueue.this.putLock;
            synchronized (object) {
                Object object2 = LinkedBlockingQueue.this.takeLock;
                synchronized (object2) {
                    this.current = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                    if (this.current != null) {
                        this.currentElement = this.current.item;
                    }
                }
            }
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            Object object = LinkedBlockingQueue.this.putLock;
            synchronized (object) {
                Object object2 = LinkedBlockingQueue.this.takeLock;
                synchronized (object2) {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    Object x = this.currentElement;
                    this.lastRet = this.current;
                    this.current = this.current.next;
                    if (this.current != null) {
                        this.currentElement = this.current.item;
                    }
                    Object object3 = x;
                    return object3;
                }
            }
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            Object object = LinkedBlockingQueue.this.putLock;
            synchronized (object) {
                Object object2 = LinkedBlockingQueue.this.takeLock;
                synchronized (object2) {
                    Node node = this.lastRet;
                    this.lastRet = null;
                    Node trail = LinkedBlockingQueue.this.head;
                    Node p = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                    while (p != null && p != node) {
                        trail = p;
                        p = p.next;
                    }
                    if (p == node) {
                        int c;
                        p.item = null;
                        trail.next = p.next;
                        if (LinkedBlockingQueue.this.last == p) {
                            LinkedBlockingQueue.this.last = trail;
                        }
                        Itr itr = this;
                        synchronized (itr) {
                            c = LinkedBlockingQueue.this.count--;
                        }
                        if (c == LinkedBlockingQueue.this.capacity) {
                            LinkedBlockingQueue.this.putLock.notifyAll();
                        }
                    }
                }
            }
        }
    }

    static class Node {
        volatile Object item;
        Node next;

        Node(Object x) {
            this.item = x;
        }
    }
}

