/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.Collection;

public abstract class WaitQueue {
    public abstract void insert(WaitNode var1);

    public abstract WaitNode extract();

    public abstract void putBack(WaitNode var1);

    public abstract boolean hasNodes();

    public abstract int getLength();

    public abstract Collection getWaitingThreads();

    public abstract boolean isWaiting(Thread var1);

    public static class WaitNode {
        boolean waiting = true;
        WaitNode next = null;
        final Thread owner = Thread.currentThread();

        public Thread getOwner() {
            return this.owner;
        }

        public synchronized boolean signal(QueuedSync sync) {
            boolean signalled = this.waiting;
            if (signalled) {
                this.waiting = false;
                this.notify();
                sync.takeOver(this);
            }
            return signalled;
        }

        public synchronized boolean doTimedWait(QueuedSync sync, long nanos) throws InterruptedException {
            if (sync.recheck(this) || !this.waiting) {
                return true;
            }
            if (nanos <= 0L) {
                this.waiting = false;
                return false;
            }
            long deadline = Utils.nanoTime() + nanos;
            try {
                do {
                    TimeUnit.NANOSECONDS.timedWait(this, nanos);
                    if (this.waiting) continue;
                    return true;
                } while ((nanos = deadline - Utils.nanoTime()) > 0L);
                this.waiting = false;
                return false;
            }
            catch (InterruptedException ex) {
                if (this.waiting) {
                    this.waiting = false;
                    throw ex;
                }
                Thread.currentThread().interrupt();
                return true;
            }
        }

        public synchronized void doWait(QueuedSync sync) throws InterruptedException {
            if (!sync.recheck(this)) {
                try {
                    while (this.waiting) {
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    if (this.waiting) {
                        this.waiting = false;
                        throw ex;
                    }
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void doWaitUninterruptibly(QueuedSync sync) {
            if (sync.recheck(this)) return;
            boolean wasInterrupted = Thread.interrupted();
            try {
                while (true) {
                    if (!this.waiting) {
                        Object var5_4 = null;
                        if (!wasInterrupted) return;
                        Thread.currentThread().interrupt();
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        wasInterrupted = true;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!wasInterrupted) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
    }

    public static interface QueuedSync {
        public boolean recheck(WaitNode var1);

        public void takeOver(WaitNode var1);
    }
}

