/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERUTCTime
extends ASN1Object {
    String time;

    public DERUTCTime(String string) {
        this.time = string;
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public DERUTCTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = simpleDateFormat.format(date);
    }

    DERUTCTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        this.time = new String(cArray);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUTCTime)) {
            return false;
        }
        return this.time.equals(((DERUTCTime)dERObject).time);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(23, this.getOctets());
    }

    public Date getAdjustedDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat.parse(this.getAdjustedTime());
    }

    public String getAdjustedTime() {
        String string = this.getTime();
        if (string.charAt(0) < '5') {
            return "20" + string;
        }
        return "19" + string;
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssz");
        return simpleDateFormat.parse(this.getTime());
    }

    public static DERUTCTime getInstance(Object object) {
        if (object == null || object instanceof DERUTCTime) {
            return (DERUTCTime)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUTCTime(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTCTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUTCTime.getInstance(aSN1TaggedObject.getObject());
    }

    private byte[] getOctets() {
        char[] cArray = this.time.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n != cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public String getTime() {
        if (this.time.indexOf(45) < 0 && this.time.indexOf(43) < 0) {
            if (this.time.length() == 11) {
                return String.valueOf(this.time.substring(0, 10)) + "00GMT+00:00";
            }
            return String.valueOf(this.time.substring(0, 12)) + "GMT+00:00";
        }
        int n = this.time.indexOf(45);
        if (n < 0) {
            n = this.time.indexOf(43);
        }
        String string = this.time;
        if (n == this.time.length() - 3) {
            string = String.valueOf(string) + "00";
        }
        if (n == 10) {
            return String.valueOf(string.substring(0, 10)) + "00GMT" + string.substring(10, 13) + ":" + string.substring(13, 15);
        }
        return String.valueOf(string.substring(0, 12)) + "GMT" + string.substring(12, 15) + ":" + string.substring(15, 17);
    }

    public int hashCode() {
        return this.time.hashCode();
    }

    public String toString() {
        return this.time;
    }
}

