/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.CertificateList;

public class CRLAnnContent
extends ASN1Encodable {
    private ASN1Sequence content;

    private CRLAnnContent(ASN1Sequence aSN1Sequence) {
        this.content = aSN1Sequence;
    }

    public static CRLAnnContent getInstance(Object object) {
        if (object instanceof CRLAnnContent) {
            return (CRLAnnContent)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CRLAnnContent((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public DERObject toASN1Object() {
        return this.content;
    }

    public CertificateList[] toCertificateListArray() {
        CertificateList[] certificateListArray = new CertificateList[this.content.size()];
        int n = 0;
        while (n != certificateListArray.length) {
            certificateListArray[n] = CertificateList.getInstance(this.content.getObjectAt(n));
            ++n;
        }
        return certificateListArray;
    }
}

