/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import org.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public class NaccacheSternEngine
implements AsymmetricBlockCipher {
    private boolean forEncryption;
    private NaccacheSternKeyParameters key;
    private Vector[] lookup = null;
    private boolean debug = false;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);

    public byte[] addCryptedBlocks(byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        if (this.forEncryption ? byArray.length > this.getOutputBlockSize() || byArray2.length > this.getOutputBlockSize() : byArray.length > this.getInputBlockSize() || byArray2.length > this.getInputBlockSize()) {
            throw new InvalidCipherTextException("BlockLength too large for simple addition.\n");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        bigInteger3 = bigInteger3.mod(this.key.getModulus());
        if (this.debug) {
            System.out.println("c(m1) as BigInteger:....... " + bigInteger);
            System.out.println("c(m2) as BigInteger:....... " + bigInteger2);
            System.out.println("c(m1)*c(m2)%n = c(m1+m2)%n: " + bigInteger3);
        }
        byte[] byArray3 = this.key.getModulus().toByteArray();
        Arrays.fill(byArray3, (byte)0);
        System.arraycopy(bigInteger3.toByteArray(), 0, byArray3, byArray3.length - bigInteger3.toByteArray().length, bigInteger3.toByteArray().length);
        return byArray3;
    }

    private static BigInteger chineseRemainder(Vector vector, Vector vector2) {
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = ONE;
        int n = 0;
        while (n < vector2.size()) {
            bigInteger2 = bigInteger2.multiply((BigInteger)vector2.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            BigInteger bigInteger3 = (BigInteger)vector2.elementAt(n2);
            BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
            BigInteger bigInteger5 = bigInteger4.modInverse(bigInteger3);
            BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5);
            bigInteger6 = bigInteger6.multiply((BigInteger)vector.elementAt(n2));
            bigInteger = bigInteger.add(bigInteger6);
            ++n2;
        }
        return bigInteger.mod(bigInteger2);
    }

    public byte[] encrypt(BigInteger bigInteger) {
        byte[] byArray = this.key.getModulus().toByteArray();
        Arrays.fill(byArray, (byte)0);
        byte[] byArray2 = this.key.getG().modPow(bigInteger, this.key.getModulus()).toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        if (this.debug) {
            System.out.println("Encrypted value is:  " + new BigInteger(byArray));
        }
        return byArray;
    }

    public int getInputBlockSize() {
        if (this.forEncryption) {
            return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
        }
        return this.key.getModulus().toByteArray().length;
    }

    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return this.key.getModulus().toByteArray().length;
        }
        return (this.key.getLowerSigmaBound() + 7) / 8 - 1;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forEncryption = bl;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        this.key = (NaccacheSternKeyParameters)cipherParameters;
        if (!this.forEncryption) {
            if (this.debug) {
                System.out.println("Constructing lookup Array");
            }
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
            Vector vector = naccacheSternPrivateKeyParameters.getSmallPrimes();
            this.lookup = new Vector[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                BigInteger bigInteger = (BigInteger)vector.elementAt(n);
                int n2 = bigInteger.intValue();
                this.lookup[n] = new Vector();
                this.lookup[n].addElement(ONE);
                if (this.debug) {
                    System.out.println("Constructing lookup ArrayList for " + n2);
                }
                BigInteger bigInteger2 = ZERO;
                int n3 = 1;
                while (n3 < n2) {
                    bigInteger2 = bigInteger2.add(naccacheSternPrivateKeyParameters.getPhi_n());
                    BigInteger bigInteger3 = bigInteger2.divide(bigInteger);
                    this.lookup[n].addElement(naccacheSternPrivateKeyParameters.getG().modPow(bigInteger3, naccacheSternPrivateKeyParameters.getModulus()));
                    ++n3;
                }
                ++n;
            }
        }
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2;
        byte[] byArray3;
        if (this.key == null) {
            throw new IllegalStateException("NaccacheStern engine not initialised");
        }
        if (n2 > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for Naccache-Stern cipher.\n");
        }
        if (!this.forEncryption && n2 < this.getInputBlockSize()) {
            throw new InvalidCipherTextException("BlockLength does not match modulus for Naccache-Stern cipher.\n");
        }
        if (n != 0 || n2 != byArray.length) {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
        } else {
            byArray3 = byArray;
        }
        BigInteger bigInteger = new BigInteger(1, byArray3);
        if (this.debug) {
            System.out.println("input as BigInteger: " + bigInteger);
        }
        if (this.forEncryption) {
            byArray2 = this.encrypt(bigInteger);
        } else {
            BigInteger bigInteger2;
            Vector<BigInteger> vector = new Vector<BigInteger>();
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.key;
            Vector vector2 = naccacheSternPrivateKeyParameters.getSmallPrimes();
            int n3 = 0;
            while (n3 < vector2.size()) {
                bigInteger2 = bigInteger.modPow(naccacheSternPrivateKeyParameters.getPhi_n().divide((BigInteger)vector2.elementAt(n3)), naccacheSternPrivateKeyParameters.getModulus());
                Vector vector3 = this.lookup[n3];
                if (this.lookup[n3].size() != ((BigInteger)vector2.elementAt(n3)).intValue()) {
                    if (this.debug) {
                        System.out.println("Prime is " + vector2.elementAt(n3) + ", lookup table has size " + vector3.size());
                    }
                    throw new InvalidCipherTextException("Error in lookup Array for " + ((BigInteger)vector2.elementAt(n3)).intValue() + ": Size mismatch. Expected ArrayList with length " + ((BigInteger)vector2.elementAt(n3)).intValue() + " but found ArrayList of length " + this.lookup[n3].size());
                }
                int n4 = vector3.indexOf(bigInteger2);
                if (n4 == -1) {
                    if (this.debug) {
                        System.out.println("Actual prime is " + vector2.elementAt(n3));
                        System.out.println("Decrypted value is " + bigInteger2);
                        System.out.println("LookupList for " + vector2.elementAt(n3) + " with size " + this.lookup[n3].size() + " is: ");
                        int n5 = 0;
                        while (n5 < this.lookup[n3].size()) {
                            System.out.println(this.lookup[n3].elementAt(n5));
                            ++n5;
                        }
                    }
                    throw new InvalidCipherTextException("Lookup failed");
                }
                vector.addElement(BigInteger.valueOf(n4));
                ++n3;
            }
            bigInteger2 = NaccacheSternEngine.chineseRemainder(vector, vector2);
            byArray2 = bigInteger2.toByteArray();
        }
        return byArray2;
    }

    public byte[] processData(byte[] byArray) throws InvalidCipherTextException {
        if (this.debug) {
            System.out.println();
        }
        if (byArray.length > this.getInputBlockSize()) {
            byte[] byArray2;
            int n = this.getInputBlockSize();
            int n2 = this.getOutputBlockSize();
            if (this.debug) {
                System.out.println("Input blocksize is:  " + n + " bytes");
                System.out.println("Output blocksize is: " + n2 + " bytes");
                System.out.println("Data has length:.... " + byArray.length + " bytes");
            }
            int n3 = 0;
            int n4 = 0;
            byte[] byArray3 = new byte[(byArray.length / n + 1) * n2];
            while (n3 < byArray.length) {
                if (n3 + n < byArray.length) {
                    byArray2 = this.processBlock(byArray, n3, n);
                    n3 += n;
                } else {
                    byArray2 = this.processBlock(byArray, n3, byArray.length - n3);
                    n3 += byArray.length - n3;
                }
                if (this.debug) {
                    System.out.println("new datapos is " + n3);
                }
                if (byArray2 != null) {
                    System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
                    n4 += byArray2.length;
                    continue;
                }
                if (this.debug) {
                    System.out.println("cipher returned null");
                }
                throw new InvalidCipherTextException("cipher returned null");
            }
            byArray2 = new byte[n4];
            System.arraycopy(byArray3, 0, byArray2, 0, n4);
            if (this.debug) {
                System.out.println("returning " + byArray2.length + " bytes");
            }
            return byArray2;
        }
        if (this.debug) {
            System.out.println("data size is less then input block size, processing directly");
        }
        return this.processBlock(byArray, 0, byArray.length);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

