/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class RC4Engine
implements StreamCipher {
    private static final int STATE_LENGTH = 256;
    private byte[] engineState = null;
    private int x = 0;
    private int y = 0;
    private byte[] workingKey = null;

    public String getAlgorithmName() {
        return "RC4";
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.workingKey = ((KeyParameter)cipherParameters).getKey();
            this.setKey(this.workingKey);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to RC4 init - " + cipherParameters.getClass().getName());
    }

    public void processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        int n4 = 0;
        while (n4 < n2) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.engineState[this.x] + this.y & 0xFF;
            byte by = this.engineState[this.x];
            this.engineState[this.x] = this.engineState[this.y];
            this.engineState[this.y] = by;
            byArray2[n4 + n3] = (byte)(byArray[n4 + n] ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
            ++n4;
        }
    }

    public void reset() {
        this.setKey(this.workingKey);
    }

    public byte returnByte(byte by) {
        this.x = this.x + 1 & 0xFF;
        this.y = this.engineState[this.x] + this.y & 0xFF;
        byte by2 = this.engineState[this.x];
        this.engineState[this.x] = this.engineState[this.y];
        this.engineState[this.y] = by2;
        return (byte)(by ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
    }

    private void setKey(byte[] byArray) {
        this.workingKey = byArray;
        this.x = 0;
        this.y = 0;
        if (this.engineState == null) {
            this.engineState = new byte[256];
        }
        int n = 0;
        while (n < 256) {
            this.engineState[n] = (byte)n;
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 256) {
            n3 = (byArray[n2] & 0xFF) + this.engineState[n4] + n3 & 0xFF;
            byte by = this.engineState[n4];
            this.engineState[n4] = this.engineState[n3];
            this.engineState[n3] = by;
            n2 = (n2 + 1) % byArray.length;
            ++n4;
        }
    }
}

