/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int key_size = 16;
    private static final int delta = -1640531527;
    private static final int d_sum = -957401312;
    private int[] _S = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    private int bytesToInt(byte[] byArray, int n) {
        return byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToInt(byArray, n);
        int n4 = this.bytesToInt(byArray, n + 4);
        int n5 = -957401312;
        int n6 = 0;
        while (n6 != 32) {
            n3 -= ((n4 -= (n3 << 4 ^ n3 >>> 5) + n3 ^ n5 + this._S[n5 >>> 11 & 3]) << 4 ^ n4 >>> 5) + n4 ^ (n5 -= -1640531527) + this._S[n5 & 3];
            ++n6;
        }
        this.unpackInt(n3, byArray2, n2);
        this.unpackInt(n4, byArray2, n2 + 4);
        return 8;
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToInt(byArray, n);
        int n4 = this.bytesToInt(byArray, n + 4);
        int n5 = 0;
        int n6 = 0;
        while (n6 != 32) {
            n4 += ((n3 += (n4 << 4 ^ n4 >>> 5) + n4 ^ n5 + this._S[n5 & 3]) << 4 ^ n3 >>> 5) + n3 ^ (n5 += -1640531527) + this._S[n5 >>> 11 & 3];
            ++n6;
        }
        this.unpackInt(n3, byArray2, n2);
        this.unpackInt(n4, byArray2, n2 + 4);
        return 8;
    }

    public String getAlgorithmName() {
        return "XTEA";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + cipherParameters.getClass().getName());
        }
        this._forEncryption = bl;
        this._initialised = true;
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.setKey(keyParameter.getKey());
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (!this._initialised) {
            throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " not initialised");
        }
        if (n + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + 8 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    public void reset() {
    }

    private void setKey(byte[] byArray) {
        this._S[0] = this.bytesToInt(byArray, 0);
        this._S[1] = this.bytesToInt(byArray, 4);
        this._S[2] = this.bytesToInt(byArray, 8);
        this._S[3] = this.bytesToInt(byArray, 12);
    }

    private void unpackInt(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2] = (byte)n;
    }
}

