/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.SignerWithRecovery;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        if (bl) {
            this.trailer = 188;
        } else if (digest instanceof SHA1Digest) {
            this.trailer = 13260;
        } else if (digest instanceof RIPEMD160Digest) {
            this.trailer = 12748;
        } else if (digest instanceof RIPEMD128Digest) {
            this.trailer = 13004;
        } else {
            throw new IllegalArgumentException("no valid trailer for digest");
        }
    }

    private void clearBlock(byte[] byArray) {
        int n = 0;
        while (n != byArray.length) {
            byArray[n] = 0;
            ++n;
        }
    }

    public byte[] generateSignature() throws CryptoException {
        int n;
        int n2 = this.digest.getDigestSize();
        int n3 = 0;
        int n4 = 0;
        if (this.trailer == 188) {
            n3 = 8;
            n4 = this.block.length - n2 - 1;
            this.digest.doFinal(this.block, n4);
            this.block[this.block.length - 1] = -68;
        } else {
            n3 = 16;
            n4 = this.block.length - n2 - 2;
            this.digest.doFinal(this.block, n4);
            this.block[this.block.length - 2] = (byte)(this.trailer >>> 8);
            this.block[this.block.length - 1] = (byte)this.trailer;
        }
        int n5 = 0;
        int n6 = (n2 + this.messageLength) * 8 + n3 + 4 - this.keyBits;
        if (n6 > 0) {
            n = this.messageLength - (n6 + 7) / 8;
            n5 = 96;
            System.arraycopy(this.mBuf, 0, this.block, n4 -= n, n);
        } else {
            n5 = 64;
            System.arraycopy(this.mBuf, 0, this.block, n4 -= this.messageLength, this.messageLength);
        }
        if (n4 - 1 > 0) {
            n = n4 - 1;
            while (n != 0) {
                this.block[n] = -69;
                --n;
            }
            int n7 = n4 - 1;
            this.block[n7] = (byte)(this.block[n7] ^ 1);
            this.block[0] = 11;
            this.block[0] = (byte)(this.block[0] | n5);
        } else {
            this.block[0] = 10;
            this.block[0] = (byte)(this.block[0] | n5);
        }
        byte[] byArray = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.mBuf);
        this.clearBlock(this.block);
        return byArray;
    }

    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }

    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)cipherParameters;
        this.cipher.init(bl, rSAKeyParameters);
        this.keyBits = rSAKeyParameters.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.mBuf = this.trailer == 188 ? new byte[this.block.length - this.digest.getDigestSize() - 2] : new byte[this.block.length - this.digest.getDigestSize() - 3];
        this.reset();
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (this.messageLength > this.mBuf.length) {
            if (this.mBuf.length > byArray2.length) {
                return false;
            }
            int n = 0;
            while (n != this.mBuf.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
        } else {
            if (this.messageLength != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n != byArray2.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void reset() {
        this.digest.reset();
        this.messageLength = 0;
        this.clearBlock(this.mBuf);
        if (this.recoveredMessage != null) {
            this.clearBlock(this.recoveredMessage);
        }
        this.recoveredMessage = null;
        this.fullMessage = false;
    }

    public void update(byte by) {
        this.digest.update(by);
        if (this.messageLength < this.mBuf.length) {
            this.mBuf[this.messageLength] = by;
        }
        ++this.messageLength;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
        if (this.messageLength < this.mBuf.length) {
            int n3 = 0;
            while (n3 < n2 && n3 + this.messageLength < this.mBuf.length) {
                this.mBuf[this.messageLength + n3] = byArray[n + n3];
                ++n3;
            }
        }
        this.messageLength += n2;
    }

    public boolean verifySignature(byte[] byArray) {
        int n;
        byte[] byArray2 = null;
        try {
            byArray2 = this.cipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        int n2 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n2 = 1;
        } else {
            n = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            switch (n) {
                case 12748: {
                    if (this.digest instanceof RIPEMD160Digest) break;
                    throw new IllegalStateException("signer should be initialised with RIPEMD160");
                }
                case 13260: {
                    if (this.digest instanceof SHA1Digest) break;
                    throw new IllegalStateException("signer should be initialised with SHA1");
                }
                case 13004: {
                    if (this.digest instanceof RIPEMD128Digest) break;
                    throw new IllegalStateException("signer should be initialised with RIPEMD128");
                }
                default: {
                    throw new IllegalArgumentException("unrecognised hash in signature");
                }
            }
            n2 = 2;
        }
        n = 0;
        n = 0;
        while (n != byArray2.length) {
            if ((byArray2[n] & 0xF ^ 0xA) == 0) break;
            ++n;
        }
        byte[] byArray3 = new byte[this.digest.getDigestSize()];
        int n3 = byArray2.length - n2 - byArray3.length;
        if (n3 - ++n <= 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.fullMessage = true;
            this.digest.reset();
            this.digest.update(byArray2, n, n3 - n);
            this.digest.doFinal(byArray3, 0);
            int n4 = 0;
            while (n4 != byArray3.length) {
                int n5 = n3 + n4;
                byArray2[n5] = (byte)(byArray2[n5] ^ byArray3[n4]);
                if (byArray2[n3 + n4] != 0) {
                    this.clearBlock(this.mBuf);
                    this.clearBlock(byArray2);
                    return false;
                }
                ++n4;
            }
            this.recoveredMessage = new byte[n3 - n];
            System.arraycopy(byArray2, n, this.recoveredMessage, 0, this.recoveredMessage.length);
        } else {
            this.fullMessage = false;
            this.digest.doFinal(byArray3, 0);
            int n6 = 0;
            while (n6 != byArray3.length) {
                int n7 = n3 + n6;
                byArray2[n7] = (byte)(byArray2[n7] ^ byArray3[n6]);
                if (byArray2[n3 + n6] != 0) {
                    this.clearBlock(this.mBuf);
                    this.clearBlock(byArray2);
                    return false;
                }
                ++n6;
            }
            this.recoveredMessage = new byte[n3 - n];
            System.arraycopy(byArray2, n, this.recoveredMessage, 0, this.recoveredMessage.length);
        }
        if (this.messageLength != 0 && !this.isSameAs(this.mBuf, this.recoveredMessage)) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        this.clearBlock(this.mBuf);
        this.clearBlock(byArray2);
        return true;
    }
}

