/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.tls.CombinedHash;
import org.bouncycastle.crypto.tls.TlsCipherSuite;
import org.bouncycastle.crypto.tls.TlsNullCipherSuite;
import org.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.bouncycastle.crypto.tls.TlsUtils;

public class RecordStream {
    private TlsProtocolHandler handler;
    private InputStream is;
    private OutputStream os;
    protected CombinedHash hash1;
    protected CombinedHash hash2;
    protected TlsCipherSuite readSuite = null;
    protected TlsCipherSuite writeSuite = null;

    protected RecordStream(TlsProtocolHandler tlsProtocolHandler, InputStream inputStream, OutputStream outputStream) {
        this.handler = tlsProtocolHandler;
        this.is = inputStream;
        this.os = outputStream;
        this.hash1 = new CombinedHash();
        this.hash2 = new CombinedHash();
        this.writeSuite = this.readSuite = new TlsNullCipherSuite();
    }

    protected void close() throws IOException {
        IOException iOException = null;
        try {
            this.is.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.os.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    protected byte[] decodeAndVerify(short s, InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        TlsUtils.readFully(byArray, inputStream);
        byte[] byArray2 = this.readSuite.decodeCiphertext(s, byArray, 0, byArray.length, this.handler);
        return byArray2;
    }

    protected void flush() throws IOException {
        this.os.flush();
    }

    public void readData() throws IOException {
        short s = TlsUtils.readUint8(this.is);
        TlsUtils.checkVersion(this.is, this.handler);
        int n = TlsUtils.readUint16(this.is);
        byte[] byArray = this.decodeAndVerify(s, this.is, n);
        this.handler.processData(s, byArray, 0, byArray.length);
    }

    protected void writeMessage(short s, byte[] byArray, int n, int n2) throws IOException {
        if (s == 22) {
            this.hash1.update(byArray, n, n2);
            this.hash2.update(byArray, n, n2);
        }
        byte[] byArray2 = this.writeSuite.encodePlaintext(s, byArray, n, n2);
        byte[] byArray3 = new byte[byArray2.length + 5];
        TlsUtils.writeUint8(s, byArray3, 0);
        TlsUtils.writeUint8((short)3, byArray3, 1);
        TlsUtils.writeUint8((short)1, byArray3, 2);
        TlsUtils.writeUint16(byArray2.length, byArray3, 3);
        System.arraycopy(byArray2, 0, byArray3, 5, byArray2.length);
        this.os.write(byArray3);
        this.os.flush();
    }
}

