/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.i18n;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.bouncycastle.i18n.LocaleString;
import org.bouncycastle.i18n.MissingEntryException;
import org.bouncycastle.i18n.filter.Filter;
import org.bouncycastle.i18n.filter.TrustedInput;
import org.bouncycastle.i18n.filter.UntrustedInput;
import org.bouncycastle.i18n.filter.UntrustedUrlInput;

public class LocalizedMessage {
    protected static final int NO_FILTER = 0;
    protected static final int FILTER = 1;
    protected static final int FILTER_URL = 2;
    protected String id;
    protected String resource;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String encoding = "ISO-8859-1";
    protected FilteredArguments arguments;
    protected FilteredArguments extraArgs = null;
    protected Filter filter = null;
    protected ClassLoader loader = null;

    public LocalizedMessage(String string, String string2) throws NullPointerException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments();
    }

    public LocalizedMessage(String string, String string2, String string3) throws NullPointerException, UnsupportedEncodingException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments();
        this.encoding = string3;
    }

    public LocalizedMessage(String string, String string2, String string3, Object[] objectArray) throws NullPointerException, UnsupportedEncodingException {
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments(objectArray);
        this.encoding = string3;
    }

    public LocalizedMessage(String string, String string2, Object[] objectArray) throws NullPointerException {
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments(objectArray);
    }

    protected String addExtraArgs(String string, Locale locale) {
        if (this.extraArgs != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            Object[] objectArray = this.extraArgs.getFilteredArgs(locale);
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n]);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected String formatWithTimeZone(String string, Object[] objectArray, Locale locale, TimeZone timeZone) {
        MessageFormat messageFormat = new MessageFormat(" ");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(string);
        if (!timeZone.equals(TimeZone.getDefault())) {
            Format[] formatArray = messageFormat.getFormats();
            int n = 0;
            while (n < formatArray.length) {
                if (formatArray[n] instanceof DateFormat) {
                    DateFormat dateFormat = (DateFormat)formatArray[n];
                    dateFormat.setTimeZone(timeZone);
                    messageFormat.setFormat(n, dateFormat);
                }
                ++n;
            }
        }
        return messageFormat.format(objectArray);
    }

    public Object[] getArguments() {
        return this.arguments.getArguments();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getEntry(String string, Locale locale, TimeZone timeZone) throws MissingEntryException {
        String string2 = this.id;
        if (string != null) {
            string2 = String.valueOf(string2) + "." + string;
        }
        try {
            ResourceBundle resourceBundle = this.loader == null ? ResourceBundle.getBundle(this.resource, locale) : ResourceBundle.getBundle(this.resource, locale);
            String string3 = resourceBundle.getString(string2);
            if (!this.encoding.equals(DEFAULT_ENCODING)) {
                string3 = new String(string3.getBytes(DEFAULT_ENCODING), this.encoding);
            }
            if (!this.arguments.isEmpty()) {
                string3 = this.formatWithTimeZone(string3, this.arguments.getFilteredArgs(locale), locale, timeZone);
            }
            string3 = this.addExtraArgs(string3, locale);
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingEntryException("Can't find entry " + string2 + " in resource file " + this.resource + ".", this.resource, string2, locale, this.loader != null ? this.loader : this.getClassLoader());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public Object[] getExtraArgs() {
        return this.extraArgs == null ? null : this.extraArgs.getArguments();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void setExtraArgument(Object object) {
        this.setExtraArguments(new Object[]{object});
    }

    public void setExtraArguments(Object[] objectArray) {
        if (objectArray != null) {
            this.extraArgs = new FilteredArguments(objectArray);
            this.extraArgs.setFilter(this.filter);
        } else {
            this.extraArgs = null;
        }
    }

    public void setFilter(Filter filter) {
        this.arguments.setFilter(filter);
        if (this.extraArgs != null) {
            this.extraArgs.setFilter(filter);
        }
        this.filter = filter;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Resource: \"").append(this.resource);
        stringBuffer.append("\" Id: \"").append(this.id).append("\"");
        stringBuffer.append(" Arguments: ").append(this.arguments.getArguments().length).append(" normal, ").append(this.extraArgs.getArguments().length).append(" extra");
        stringBuffer.append(" Encoding: ").append(this.encoding);
        stringBuffer.append(" ClassLoader: ").append(this.loader);
        return stringBuffer.toString();
    }

    protected class FilteredArguments {
        protected Filter filter = null;
        protected boolean[] isLocaleSpecific;
        protected int[] argFilterType;
        protected Object[] arguments;
        protected Object[] unpackedArgs;
        protected Object[] filteredArgs;

        FilteredArguments() {
            this(new Object[0]);
        }

        FilteredArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.unpackedArgs = new Object[objectArray.length];
            this.filteredArgs = new Object[objectArray.length];
            this.isLocaleSpecific = new boolean[objectArray.length];
            this.argFilterType = new int[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof TrustedInput) {
                    this.unpackedArgs[n] = ((TrustedInput)objectArray[n]).getInput();
                    this.argFilterType[n] = 0;
                } else if (objectArray[n] instanceof UntrustedInput) {
                    this.unpackedArgs[n] = ((UntrustedInput)objectArray[n]).getInput();
                    this.argFilterType[n] = objectArray[n] instanceof UntrustedUrlInput ? 2 : 1;
                } else {
                    this.unpackedArgs[n] = objectArray[n];
                    this.argFilterType[n] = 1;
                }
                this.isLocaleSpecific[n] = this.unpackedArgs[n] instanceof LocaleString;
                ++n;
            }
        }

        private Object filter(int n, Object object) {
            if (this.filter != null) {
                Object object2 = object == null ? "null" : object;
                switch (n) {
                    case 0: {
                        return object2;
                    }
                    case 1: {
                        return this.filter.doFilter(object2.toString());
                    }
                    case 2: {
                        return this.filter.doFilterUrl(object2.toString());
                    }
                }
                return null;
            }
            return object;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Object[] getFilteredArgs(Locale locale) {
            Object[] objectArray = new Object[this.unpackedArgs.length];
            int n = 0;
            while (n < this.unpackedArgs.length) {
                Object object;
                if (this.filteredArgs[n] != null) {
                    object = this.filteredArgs[n];
                } else {
                    object = this.unpackedArgs[n];
                    if (this.isLocaleSpecific[n]) {
                        object = ((LocaleString)object).getLocaleString(locale);
                        object = this.filter(this.argFilterType[n], object);
                    } else {
                        this.filteredArgs[n] = object = this.filter(this.argFilterType[n], object);
                    }
                }
                objectArray[n] = object;
                ++n;
            }
            return objectArray;
        }

        public boolean isEmpty() {
            return this.unpackedArgs.length == 0;
        }

        public void setFilter(Filter filter) {
            if (filter != this.filter) {
                int n = 0;
                while (n < this.unpackedArgs.length) {
                    this.filteredArgs[n] = null;
                    ++n;
                }
            }
            this.filter = filter;
        }
    }
}

