/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertificateFactory;
import org.bouncycastle.openssl.PEMWriter;

public class PKIXCertPath
extends CertPath {
    static final List certPathEncodings;
    private List certificates;

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PkiPath");
        arrayList.add("PEM");
        arrayList.add("PKCS7");
        certPathEncodings = Collections.unmodifiableList(arrayList);
    }

    PKIXCertPath(InputStream inputStream, String string) throws CertificateException {
        block8: {
            super("X.509");
            try {
                if (string.equalsIgnoreCase("PkiPath")) {
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
                    DERObject dERObject = aSN1InputStream.readObject();
                    if (!(dERObject instanceof ASN1Sequence)) {
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    while (enumeration.hasMoreElements()) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
                        dEROutputStream.writeObject(enumeration.nextElement());
                        dEROutputStream.close();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        this.certificates.add(0, certificateFactory.generateCertificate(byteArrayInputStream));
                    }
                    break block8;
                }
                if (string.equalsIgnoreCase("PKCS7") || string.equalsIgnoreCase("PEM")) {
                    inputStream = new BufferedInputStream(inputStream);
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    Certificate certificate = null;
                    while ((certificate = certificateFactory.generateCertificate(inputStream)) != null) {
                        this.certificates.add(certificate);
                    }
                    break block8;
                }
                throw new CertificateException("unsupported encoding: " + string);
            }
            catch (IOException iOException) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + iOException.toString());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new CertificateException("BouncyCastle provider not found while trying to get a CertificateFactory:\n" + noSuchProviderException.toString());
            }
        }
        this.certificates = this.sortCerts(this.certificates);
    }

    PKIXCertPath(List list) {
        super("X.509");
        this.certificates = this.sortCerts(new ArrayList(list));
    }

    public List getCertificates() {
        return Collections.unmodifiableList(new ArrayList(this.certificates));
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Object e;
        Iterator iterator = this.getEncodings();
        if (iterator.hasNext() && (e = iterator.next()) instanceof String) {
            return this.getEncoded((String)e);
        }
        return null;
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        if (string.equalsIgnoreCase("PkiPath")) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ListIterator listIterator = this.certificates.listIterator(this.certificates.size());
            while (listIterator.hasPrevious()) {
                aSN1EncodableVector.add(this.toASN1Object((X509Certificate)listIterator.previous()));
            }
            return this.toDEREncoded(new DERSequence(aSN1EncodableVector));
        }
        if (string.equalsIgnoreCase("PKCS7")) {
            ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            int n = 0;
            while (n != this.certificates.size()) {
                aSN1EncodableVector.add(this.toASN1Object((X509Certificate)this.certificates.get(n)));
                ++n;
            }
            SignedData signedData = new SignedData(new DERInteger(1), new DERSet(), contentInfo, new DERSet(aSN1EncodableVector), null, new DERSet());
            return this.toDEREncoded(new ContentInfo(PKCSObjectIdentifiers.signedData, signedData));
        }
        if (string.equalsIgnoreCase("PEM")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PEMWriter pEMWriter = new PEMWriter(new OutputStreamWriter(byteArrayOutputStream));
            try {
                int n = 0;
                while (n != this.certificates.size()) {
                    pEMWriter.writeObject(this.certificates.get(n));
                    ++n;
                }
                pEMWriter.close();
            }
            catch (Exception exception) {
                throw new CertificateEncodingException("can't encode certificate for PEM encoded path");
            }
            return byteArrayOutputStream.toByteArray();
        }
        throw new CertificateEncodingException("unsupported encoding: " + string);
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }

    private List sortCerts(List list) {
        if (list.size() < 2) {
            return list;
        }
        try {
            Object object;
            int n;
            Serializable serializable;
            X509Principal x509Principal = PrincipalUtil.getIssuerX509Principal((X509Certificate)list.get(0));
            boolean bl = true;
            int n2 = 1;
            while (n2 != list.size()) {
                serializable = (X509Certificate)list.get(n2);
                if (!x509Principal.equals(PrincipalUtil.getSubjectX509Principal((X509Certificate)serializable))) {
                    bl = false;
                    break;
                }
                x509Principal = PrincipalUtil.getIssuerX509Principal((X509Certificate)list.get(n2));
                ++n2;
            }
            if (bl) {
                return list;
            }
            serializable = new ArrayList(list.size());
            int n3 = 0;
            while (n3 < list.size()) {
                X509Certificate x509Certificate = (X509Certificate)list.get(n3);
                n = 0;
                object = PrincipalUtil.getSubjectX509Principal(x509Certificate);
                int n4 = 0;
                while (n4 != list.size()) {
                    X509Certificate x509Certificate2 = (X509Certificate)list.get(n4);
                    if (PrincipalUtil.getIssuerX509Principal(x509Certificate2).equals(object)) {
                        n = 1;
                        break;
                    }
                    ++n4;
                }
                if (n == 0) {
                    serializable.add(x509Certificate);
                    list.remove(n3);
                }
                ++n3;
            }
            if (serializable.size() > 1) {
                int n5 = 0;
                while (n5 != list.size()) {
                    serializable.add(list.get(n5));
                    ++n5;
                }
                return serializable;
            }
            int n6 = 0;
            while (n6 != serializable.size()) {
                x509Principal = PrincipalUtil.getIssuerX509Principal((X509Certificate)serializable.get(n6));
                n = 0;
                while (n < list.size()) {
                    object = (X509Certificate)list.get(n);
                    if (x509Principal.equals(PrincipalUtil.getSubjectX509Principal((X509Certificate)object))) {
                        serializable.add(object);
                        list.remove(n);
                        break;
                    }
                    ++n;
                }
                ++n6;
            }
            n = 0;
            while (n != list.size()) {
                serializable.add(list.get(n));
                ++n;
            }
            return serializable;
        }
        catch (Exception exception) {
            return list;
        }
    }

    private DERObject toASN1Object(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            return new ASN1InputStream(x509Certificate.getEncoded()).readObject();
        }
        catch (Exception exception) {
            throw new CertificateEncodingException("Exception while encoding certificate: " + exception.toString());
        }
    }

    private byte[] toDEREncoded(ASN1Encodable aSN1Encodable) throws CertificateEncodingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(aSN1Encodable);
            dEROutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("Exeption thrown: " + iOException);
        }
    }
}

