/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidatorException;
import org.bouncycastle.jce.cert.CertPathValidatorResult;
import org.bouncycastle.jce.cert.CertPathValidatorSpi;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.PKIXCertPathChecker;
import org.bouncycastle.jce.cert.PKIXCertPathValidatorResult;
import org.bouncycastle.jce.cert.PKIXParameters;
import org.bouncycastle.jce.cert.PolicyNode;
import org.bouncycastle.jce.cert.PolicyQualifierInfo;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CRLSelector;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;
    private static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    private void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey) throws AnnotatedException {
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(this.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot extract issuer from certificate: " + iOException, iOException);
        }
        x509CRLSelector.setCertificateChecking(x509Certificate);
        Iterator iterator = this.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            X509CRL x509CRL = (X509CRL)iterator.next();
            if (!x509Certificate.getNotAfter().after(x509CRL.getThisUpdate())) continue;
            if (x509CRL.getNextUpdate() == null || date.before(x509CRL.getNextUpdate())) {
                bl = true;
            }
            if (!(x509Certificate2 == null || (object3 = x509Certificate2.getKeyUsage()) == null || ((boolean[])object3).length >= 7 && object3[6])) {
                throw new AnnotatedException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate2);
            }
            try {
                x509CRL.verify(publicKey, "BC");
            }
            catch (Exception exception) {
                throw new AnnotatedException("can't verify CRL: " + exception, exception);
            }
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate.getSerialNumber());
            if (x509CRLEntry != null && !date.before(x509CRLEntry.getRevocationDate())) {
                object3 = null;
                if (x509CRLEntry.hasExtensions() && (object2 = DEREnumerated.getInstance(this.getExtensionValue(x509CRLEntry, X509Extensions.ReasonCode.getId()))) != null) {
                    object3 = crlReasons[((DEREnumerated)object2).getValue().intValue()];
                }
                object2 = "Certificate revocation after " + x509CRLEntry.getRevocationDate();
                if (object3 != null) {
                    object2 = String.valueOf(object2) + ", reason: " + (String)object3;
                }
                throw new AnnotatedException((String)object2);
            }
            object3 = this.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT);
            object2 = this.getExtensionValue(x509CRL, DELTA_CRL_INDICATOR);
            if (object2 != null) {
                object = new X509CRLSelector();
                try {
                    ((X509CRLSelector)object).addIssuerName(this.getIssuerPrincipal(x509CRL).getEncoded());
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("can't extract issuer from certificate: " + iOException, iOException);
                }
                ((X509CRLSelector)object).setMinCRLNumber(((DERInteger)object2).getPositiveValue());
                ((X509CRLSelector)object).setMaxCRLNumber(((DERInteger)this.getExtensionValue(x509CRL, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                boolean bl2 = false;
                Iterator iterator2 = this.findCRLs((X509CRLSelector)object, pKIXParameters.getCertStores()).iterator();
                while (iterator2.hasNext()) {
                    X509CRL x509CRL2 = (X509CRL)iterator2.next();
                    DERObject dERObject = this.getExtensionValue(x509CRL2, ISSUING_DISTRIBUTION_POINT);
                    if (object3 == null) {
                        if (dERObject != null) continue;
                        bl2 = true;
                        break;
                    }
                    if (!((DERObject)object3).equals(dERObject)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    throw new AnnotatedException("No base CRL for delta CRL");
                }
            }
            if (object3 == null) continue;
            object = IssuingDistributionPoint.getInstance(object3);
            BasicConstraints basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
            if (((IssuingDistributionPoint)object).onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                throw new AnnotatedException("CA Cert CRL only contains user certificates");
            }
            if (((IssuingDistributionPoint)object).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                throw new AnnotatedException("End CRL only contains CA certificates");
            }
            if (!((IssuingDistributionPoint)object).onlyContainsAttributeCerts()) continue;
            throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted");
        }
        if (!bl) {
            throw new AnnotatedException("no valid CRL found");
        }
    }

    private void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private void checkExcludedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkExcludedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkPermittedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkPermittedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator iterator;
        int n;
        Object object;
        Object object2;
        Object object3;
        Set<String> set;
        PublicKey publicKey;
        X509Principal x509Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = this.getValidDate(pKIXParameters);
        Set set2 = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = this.findTrustAnchor((X509Certificate)list.get(list.size() - 1), certPath, list.size() - 1, pKIXParameters.getTrustAnchors());
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found.", null, certPath, -1);
        }
        int n3 = 0;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        List[] listArray = new ArrayList[n2 + 1];
        int n4 = 0;
        while (n4 < listArray.length) {
            listArray[n4] = new ArrayList();
            ++n4;
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet3, null, new HashSet(), ANY_POLICY, false);
        listArray[0].add(pKIXPolicyNode);
        Set set3 = new HashSet();
        Set set4 = new HashSet();
        Set set5 = new HashSet();
        Set set6 = new HashSet();
        Set set7 = new HashSet();
        Set set8 = new HashSet();
        HashSet hashSet4 = null;
        int n5 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n6 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n7 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x509Principal = this.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x509Principal = new X509Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, n3);
        }
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n8 = n2;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        List list2 = pKIXParameters.getCertPathCheckers();
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            ((PKIXCertPathChecker)iterator2.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        n3 = list.size() - 1;
        while (n3 >= 0) {
            try {
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Object object10;
                Object object11;
                int n9 = n2 - n3;
                x509Certificate2 = (X509Certificate)list.get(n3);
                try {
                    x509Certificate2.verify(publicKey, "BC");
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new CertPathValidatorException("Could not validate certificate signature.", (Throwable)generalSecurityException, certPath, n3);
                }
                try {
                    x509Certificate2.checkValidity(date);
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    throw new CertPathValidatorException("Could not validate certificate: " + certificateExpiredException.getMessage(), (Throwable)certificateExpiredException, certPath, n3);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    throw new CertPathValidatorException("Could not validate certificate: " + certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException, certPath, n3);
                }
                if (pKIXParameters.isRevocationEnabled()) {
                    this.checkCRLs(pKIXParameters, x509Certificate2, date, x509Certificate, publicKey);
                }
                if (!this.getEncodedIssuerPrincipal(x509Certificate2).equals(x509Principal)) {
                    throw new CertPathValidatorException("IssuerName(" + this.getEncodedIssuerPrincipal(x509Certificate2) + ") does not match SubjectName(" + x509Principal + ") of signing certificate", null, certPath, n3);
                }
                if (!this.isSelfIssued(x509Certificate2) || n9 >= n2) {
                    set = this.getSubjectPrincipal(x509Certificate2);
                    object3 = new ASN1InputStream(new ByteArrayInputStream(((X509Principal)((Object)set)).getEncoded()));
                    try {
                        object2 = (ASN1Sequence)((ASN1InputStream)object3).readObject();
                    }
                    catch (IOException iOException) {
                        throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                    }
                    this.checkPermittedDN(set3, (ASN1Sequence)object2);
                    this.checkExcludedDN(set6, (ASN1Sequence)object2);
                    object11 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                    if (object11 != null) {
                        int n10 = 0;
                        while (n10 < ((ASN1Sequence)object11).size()) {
                            object10 = (ASN1TaggedObject)((ASN1Sequence)object11).getObjectAt(n10);
                            switch (((ASN1TaggedObject)object10).getTagNo()) {
                                case 1: {
                                    object = DERIA5String.getInstance((ASN1TaggedObject)object10, true).getString();
                                    this.checkPermittedEmail(set4, (String)object);
                                    this.checkExcludedEmail(set7, (String)object);
                                    break;
                                }
                                case 4: {
                                    object9 = ASN1Sequence.getInstance((ASN1TaggedObject)object10, true);
                                    this.checkPermittedDN(set3, (ASN1Sequence)object9);
                                    this.checkExcludedDN(set6, (ASN1Sequence)object9);
                                    break;
                                }
                                case 7: {
                                    object8 = ASN1OctetString.getInstance((ASN1TaggedObject)object10, true).getOctets();
                                    this.checkPermittedIP(set5, (byte[])object8);
                                    this.checkExcludedIP(set8, (byte[])object8);
                                }
                            }
                            ++n10;
                        }
                    }
                }
                if ((set = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                    object3 = ((ASN1Sequence)((Object)set)).getObjects();
                    object2 = new HashSet();
                    while (object3.hasMoreElements()) {
                        boolean bl;
                        object11 = PolicyInformation.getInstance(object3.nextElement());
                        DERObjectIdentifier dERObjectIdentifier2 = ((PolicyInformation)object11).getPolicyIdentifier();
                        object2.add(dERObjectIdentifier2.getId());
                        if (ANY_POLICY.equals(dERObjectIdentifier2.getId()) || (bl = this.processCertD1i(n9, listArray, dERObjectIdentifier2, (Set)(object10 = this.getQualifierSet(((PolicyInformation)object11).getPolicyQualifiers()))))) continue;
                        this.processCertD1ii(n9, listArray, dERObjectIdentifier2, (Set)object10);
                    }
                    if (hashSet4 == null || hashSet4.contains(ANY_POLICY)) {
                        hashSet4 = object2;
                    } else {
                        object11 = hashSet4.iterator();
                        HashSet<Object> hashSet5 = new HashSet<Object>();
                        while (object11.hasNext()) {
                            object10 = object11.next();
                            if (!object2.contains(object10)) continue;
                            hashSet5.add(object10);
                        }
                        hashSet4 = hashSet5;
                    }
                    if (n6 > 0 || n9 < n2 && this.isSelfIssued(x509Certificate2)) {
                        object3 = ((ASN1Sequence)((Object)set)).getObjects();
                        while (object3.hasMoreElements()) {
                            object11 = PolicyInformation.getInstance(object3.nextElement());
                            if (!ANY_POLICY.equals(((PolicyInformation)object11).getPolicyIdentifier().getId())) continue;
                            Set set9 = this.getQualifierSet(((PolicyInformation)object11).getPolicyQualifiers());
                            object10 = listArray[n9 - 1];
                            int n11 = 0;
                            while (n11 < object10.size()) {
                                object9 = (PKIXPolicyNode)object10.get(n11);
                                object8 = ((PKIXPolicyNode)object9).getExpectedPolicies().iterator();
                                while (object8.hasNext()) {
                                    Object object12;
                                    object7 = object8.next();
                                    if (object7 instanceof String) {
                                        object6 = (String)object7;
                                    } else {
                                        if (!(object7 instanceof DERObjectIdentifier)) continue;
                                        object6 = ((DERObjectIdentifier)object7).getId();
                                    }
                                    boolean bl = false;
                                    object5 = ((PKIXPolicyNode)object9).getChildren();
                                    while (object5.hasNext()) {
                                        object12 = (PKIXPolicyNode)object5.next();
                                        if (!((String)object6).equals(((PKIXPolicyNode)object12).getValidPolicy())) continue;
                                        bl = true;
                                    }
                                    if (bl) continue;
                                    object12 = new HashSet();
                                    object12.add(object6);
                                    object4 = new PKIXPolicyNode(new ArrayList(), n9, (Set)object12, (PolicyNode)object9, set9, (String)object6, false);
                                    ((PKIXPolicyNode)object9).addChild((PKIXPolicyNode)object4);
                                    listArray[n9].add(object4);
                                }
                                ++n11;
                            }
                            break block48;
                        }
                    }
                    int n12 = n9 - 1;
                    while (n12 >= 0) {
                        List list3 = listArray[n12];
                        int n13 = 0;
                        while (n13 < list3.size()) {
                            object = (PKIXPolicyNode)list3.get(n13);
                            if (!((PKIXPolicyNode)object).hasChildren() && (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object)) == null) break;
                            ++n13;
                        }
                        --n12;
                    }
                    Set<String> set10 = x509Certificate2.getCriticalExtensionOIDs();
                    if (set10 != null) {
                        boolean bl = set10.contains(CERTIFICATE_POLICIES);
                        object = listArray[n9];
                        int n14 = 0;
                        while (n14 < object.size()) {
                            object8 = (PKIXPolicyNode)object.get(n14);
                            ((PKIXPolicyNode)object8).setCritical(bl);
                            ++n14;
                        }
                    }
                }
                if (set == null) {
                    pKIXPolicyNode = null;
                }
                if (n5 <= 0 && pKIXPolicyNode == null) {
                    throw new CertPathValidatorException("No valid policy tree found when one expected.");
                }
                if (n9 != n2) {
                    int n15;
                    int n16;
                    DERInteger dERInteger;
                    if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                        throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                    }
                    object3 = this.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                    if (object3 != null) {
                        object2 = (ASN1Sequence)object3;
                        int n17 = 0;
                        while (n17 < ((ASN1Sequence)object2).size()) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object2).getObjectAt(n17);
                            object10 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
                            object = (DERObjectIdentifier)aSN1Sequence.getObjectAt(1);
                            if (ANY_POLICY.equals(((DERObjectIdentifier)object10).getId())) {
                                throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                            }
                            if (ANY_POLICY.equals(((DERObjectIdentifier)object).getId())) {
                                throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                            }
                            ++n17;
                        }
                    }
                    if (object3 != null) {
                        object2 = (ASN1Sequence)object3;
                        object11 = new HashMap();
                        HashSet<String> hashSet6 = new HashSet<String>();
                        int n18 = 0;
                        while (n18 < ((ASN1Sequence)object2).size()) {
                            object = (ASN1Sequence)((ASN1Sequence)object2).getObjectAt(n18);
                            String string = ((DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(0)).getId();
                            object8 = ((DERObjectIdentifier)((ASN1Sequence)object).getObjectAt(1)).getId();
                            if (!object11.containsKey(string)) {
                                object7 = new HashSet();
                                object7.add(object8);
                                object11.put(string, object7);
                                hashSet6.add(string);
                            } else {
                                object7 = (Set)object11.get(string);
                                object7.add(object8);
                            }
                            ++n18;
                        }
                        object = hashSet6.iterator();
                        block57: while (object.hasNext()) {
                            String string = (String)object.next();
                            if (n7 > 0) {
                                boolean bl = false;
                                object7 = listArray[n9].iterator();
                                while (object7.hasNext()) {
                                    object6 = (PKIXPolicyNode)object7.next();
                                    if (!((PKIXPolicyNode)object6).getValidPolicy().equals(string)) continue;
                                    bl = true;
                                    ((PKIXPolicyNode)object6).expectedPolicies = (Set)object11.get(string);
                                    break;
                                }
                                if (bl) continue;
                                object7 = listArray[n9].iterator();
                                while (object7.hasNext()) {
                                    PKIXPolicyNode pKIXPolicyNode2;
                                    object6 = (PKIXPolicyNode)object7.next();
                                    if (!ANY_POLICY.equals(((PKIXPolicyNode)object6).getValidPolicy())) continue;
                                    Set set11 = null;
                                    object5 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES);
                                    Enumeration enumeration = ((ASN1Sequence)object5).getObjects();
                                    while (enumeration.hasMoreElements()) {
                                        object4 = PolicyInformation.getInstance(enumeration.nextElement());
                                        if (!ANY_POLICY.equals(((PolicyInformation)object4).getPolicyIdentifier().getId())) continue;
                                        set11 = this.getQualifierSet(((PolicyInformation)object4).getPolicyQualifiers());
                                        break;
                                    }
                                    boolean bl2 = false;
                                    if (x509Certificate2.getCriticalExtensionOIDs() != null) {
                                        bl2 = x509Certificate2.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                                    }
                                    if (!ANY_POLICY.equals((pKIXPolicyNode2 = (PKIXPolicyNode)((PKIXPolicyNode)object6).getParent()).getValidPolicy())) continue block57;
                                    PKIXPolicyNode pKIXPolicyNode3 = new PKIXPolicyNode(new ArrayList(), n9, (Set)object11.get(string), pKIXPolicyNode2, set11, string, bl2);
                                    pKIXPolicyNode2.addChild(pKIXPolicyNode3);
                                    listArray[n9].add(pKIXPolicyNode3);
                                    continue block57;
                                }
                                continue;
                            }
                            if (n7 > 0) continue;
                            Iterator iterator3 = listArray[n9].iterator();
                            while (iterator3.hasNext()) {
                                object7 = (PKIXPolicyNode)iterator3.next();
                                if (!((PKIXPolicyNode)object7).getValidPolicy().equals(string)) continue;
                                object6 = (PKIXPolicyNode)((PKIXPolicyNode)object7).getParent();
                                ((PKIXPolicyNode)object6).removeChild((PKIXPolicyNode)object7);
                                iterator3.remove();
                                int n19 = n9 - 1;
                                while (n19 >= 0) {
                                    object5 = listArray[n19];
                                    int n20 = 0;
                                    while (n20 < object5.size()) {
                                        object4 = (PKIXPolicyNode)object5.get(n20);
                                        if (!((PKIXPolicyNode)object4).hasChildren() && (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object4)) == null) break;
                                        ++n20;
                                    }
                                    --n19;
                                }
                            }
                        }
                    }
                    if ((object2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                        ASN1Sequence aSN1Sequence;
                        object11 = new NameConstraints((ASN1Sequence)object2);
                        ASN1Sequence aSN1Sequence2 = ((NameConstraints)object11).getPermittedSubtrees();
                        if (aSN1Sequence2 != null) {
                            Enumeration enumeration = aSN1Sequence2.getObjects();
                            while (enumeration.hasMoreElements()) {
                                object = GeneralSubtree.getInstance(enumeration.nextElement());
                                GeneralName generalName = ((GeneralSubtree)object).getBase();
                                switch (generalName.getTagNo()) {
                                    case 1: {
                                        set4 = this.intersectEmail(set4, DERIA5String.getInstance(generalName.getName()).getString());
                                        break;
                                    }
                                    case 4: {
                                        set3 = this.intersectDN(set3, (ASN1Sequence)generalName.getName());
                                        break;
                                    }
                                    case 7: {
                                        set5 = this.intersectIP(set5, ASN1OctetString.getInstance(generalName.getName()).getOctets());
                                        break;
                                    }
                                }
                            }
                        }
                        if ((aSN1Sequence = ((NameConstraints)object11).getExcludedSubtrees()) != null) {
                            object = aSN1Sequence.getObjects();
                            while (object.hasMoreElements()) {
                                GeneralSubtree generalSubtree = GeneralSubtree.getInstance(object.nextElement());
                                GeneralName generalName = generalSubtree.getBase();
                                switch (generalName.getTagNo()) {
                                    case 1: {
                                        set7 = this.unionEmail(set7, DERIA5String.getInstance(generalName.getName()).getString());
                                        break;
                                    }
                                    case 4: {
                                        set6 = this.unionDN(set6, (ASN1Sequence)generalName.getName());
                                        break;
                                    }
                                    case 7: {
                                        set8 = this.unionIP(set8, ASN1OctetString.getInstance(generalName.getName()).getOctets());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (!this.isSelfIssued(x509Certificate2)) {
                        if (n5 != 0) {
                            --n5;
                        }
                        if (n7 != 0) {
                            --n7;
                        }
                        if (n6 != 0) {
                            --n6;
                        }
                    }
                    if ((object11 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                        Enumeration enumeration = ((ASN1Sequence)object11).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n >= n5) break;
                                    n5 = n;
                                    break;
                                }
                                case 1: {
                                    n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n >= n7) break;
                                    n7 = n;
                                    break;
                                }
                            }
                        }
                    }
                    if ((dERInteger = (DERInteger)this.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (n16 = dERInteger.getValue().intValue()) < n6) {
                        n6 = n16;
                    }
                    if ((object10 = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                        if (!((BasicConstraints)object10).isCA()) {
                            throw new CertPathValidatorException("Not a CA certificate");
                        }
                    } else {
                        throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                    }
                    if (!this.isSelfIssued(x509Certificate2)) {
                        if (n8 <= 0) {
                            throw new CertPathValidatorException("Max path length not greater than zero");
                        }
                        --n8;
                    }
                    if (object10 != null && (object = ((BasicConstraints)object10).getPathLenConstraint()) != null && (n15 = ((BigInteger)object).intValue()) < n8) {
                        n8 = n15;
                    }
                    if ((object = (Object)x509Certificate2.getKeyUsage()) != null && object[5] == false) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n3);
                    }
                    HashSet<String> hashSet7 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                    hashSet7.remove(KEY_USAGE);
                    hashSet7.remove(CERTIFICATE_POLICIES);
                    hashSet7.remove(POLICY_MAPPINGS);
                    hashSet7.remove(INHIBIT_ANY_POLICY);
                    hashSet7.remove(ISSUING_DISTRIBUTION_POINT);
                    hashSet7.remove(DELTA_CRL_INDICATOR);
                    hashSet7.remove(POLICY_CONSTRAINTS);
                    hashSet7.remove(BASIC_CONSTRAINTS);
                    hashSet7.remove(SUBJECT_ALTERNATIVE_NAME);
                    hashSet7.remove(NAME_CONSTRAINTS);
                    iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((PKIXCertPathChecker)iterator.next()).check(x509Certificate2, hashSet7);
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
                        }
                    }
                    if (!hashSet7.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
                    }
                }
                x509Certificate = x509Certificate2;
                publicKey = x509Certificate.getPublicKey();
                try {
                    x509Principal = this.getSubjectPrincipal(x509Certificate);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CertPathValidatorException(String.valueOf(x509Certificate.getSubjectDN().getName()) + " :" + illegalArgumentException.toString());
                }
                algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
                dERObjectIdentifier = algorithmIdentifier.getObjectId();
                dEREncodable = algorithmIdentifier.getParameters();
            }
            catch (AnnotatedException annotatedException) {
                throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, n3);
            }
            --n3;
        }
        if (!this.isSelfIssued(x509Certificate2) && n5 != 0) {
            --n5;
        }
        try {
            set = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS);
            if (set != null) {
                object3 = ((ASN1Sequence)((Object)set)).getObjects();
                while (object3.hasMoreElements()) {
                    object2 = (ASN1TaggedObject)object3.nextElement();
                    switch (((ASN1TaggedObject)object2).getTagNo()) {
                        case 0: {
                            n = DERInteger.getInstance(object2).getValue().intValue();
                            if (n != 0) break;
                            n5 = 0;
                            break;
                        }
                    }
                }
            }
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, n3);
        }
        set = x509Certificate2.getCriticalExtensionOIDs();
        if (set != null) {
            set = new HashSet(set);
            set.remove(KEY_USAGE);
            set.remove(CERTIFICATE_POLICIES);
            set.remove(POLICY_MAPPINGS);
            set.remove(INHIBIT_ANY_POLICY);
            set.remove(ISSUING_DISTRIBUTION_POINT);
            set.remove(DELTA_CRL_INDICATOR);
            set.remove(POLICY_CONSTRAINTS);
            set.remove(BASIC_CONSTRAINTS);
            set.remove(SUBJECT_ALTERNATIVE_NAME);
            set.remove(NAME_CONSTRAINTS);
        } else {
            set = new HashSet();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            try {
                ((PKIXCertPathChecker)iterator.next()).check(x509Certificate2, set);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
            }
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
        }
        if (pKIXPolicyNode == null) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                throw new CertPathValidatorException("Explicit policy requested but none available.");
            }
            object3 = null;
        } else if (this.isAnyPolicy(set2)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet4.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none available.");
                }
                object2 = new HashSet();
                int n21 = 0;
                while (n21 < listArray.length) {
                    ArrayList arrayList = listArray[n21];
                    int n22 = 0;
                    while (n22 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n22);
                        if (ANY_POLICY.equals(((PKIXPolicyNode)object).getValidPolicy())) {
                            Iterator iterator4 = ((PKIXPolicyNode)object).getChildren();
                            while (iterator4.hasNext()) {
                                object2.add(iterator4.next());
                            }
                        }
                        ++n22;
                    }
                    ++n21;
                }
                Iterator iterator5 = object2.iterator();
                while (iterator5.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)iterator5.next();
                    object = pKIXPolicyNode4.getValidPolicy();
                    hashSet4.contains(object);
                }
                if (pKIXPolicyNode != null) {
                    int n23 = n2 - 1;
                    while (n23 >= 0) {
                        object = listArray[n23];
                        int n24 = 0;
                        while (n24 < object.size()) {
                            PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)object.get(n24);
                            if (!pKIXPolicyNode5.hasChildren()) {
                                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode5);
                            }
                            ++n24;
                        }
                        --n23;
                    }
                }
            }
            object3 = pKIXPolicyNode;
        } else {
            object2 = new HashSet();
            int n25 = 0;
            while (n25 < listArray.length) {
                ArrayList arrayList = listArray[n25];
                int n26 = 0;
                while (n26 < arrayList.size()) {
                    object = (PKIXPolicyNode)arrayList.get(n26);
                    if (ANY_POLICY.equals(((PKIXPolicyNode)object).getValidPolicy())) {
                        Iterator iterator6 = ((PKIXPolicyNode)object).getChildren();
                        while (iterator6.hasNext()) {
                            PKIXPolicyNode pKIXPolicyNode6 = (PKIXPolicyNode)iterator6.next();
                            if (ANY_POLICY.equals(pKIXPolicyNode6.getValidPolicy())) continue;
                            object2.add(pKIXPolicyNode6);
                        }
                    }
                    ++n26;
                }
                ++n25;
            }
            Iterator iterator7 = object2.iterator();
            while (iterator7.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)iterator7.next();
                object = pKIXPolicyNode7.getValidPolicy();
                if (set2.contains(object)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode7);
            }
            if (pKIXPolicyNode != null) {
                int n27 = n2 - 1;
                while (n27 >= 0) {
                    object = listArray[n27];
                    int n28 = 0;
                    while (n28 < object.size()) {
                        PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)object.get(n28);
                        if (!pKIXPolicyNode8.hasChildren()) {
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode8);
                        }
                        ++n28;
                    }
                    --n27;
                }
            }
            object3 = pKIXPolicyNode;
        }
        if (n5 > 0 || object3 != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object3, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }

    private final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("cannot extract crl: " + certStoreException, certStoreException);
            }
        }
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    final TrustAnchor findTrustAnchor(X509Certificate var1_1, CertPath var2_2, int var3_3, Set var4_4) throws CertPathValidatorException {
        var5_5 = var4_4.iterator();
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = new X509CertSelector();
        try {
            var9_9.setSubject(this.getEncodedIssuerPrincipal(var1_1).getEncoded());
            if (true) ** GOTO lbl42
        }
        catch (IOException var10_10) {
            throw new CertPathValidatorException(var10_10);
        }
        catch (AnnotatedException var10_11) {
            throw new CertPathValidatorException(var10_11.getUnderlyingException());
        }
        do {
            if ((var6_6 = (TrustAnchor)var5_5.next()).getTrustedCert() != null) {
                if (var9_9.match(var6_6.getTrustedCert())) {
                    var7_7 = var6_6.getTrustedCert().getPublicKey();
                } else {
                    var6_6 = null;
                }
            } else if (var6_6.getCAName() != null && var6_6.getCAPublicKey() != null) {
                try {
                    var10_12 = this.getEncodedIssuerPrincipal(var1_1);
                    var11_15 = new X509Principal(var6_6.getCAName());
                    if (var10_12.equals(var11_15)) {
                        var7_7 = var6_6.getCAPublicKey();
                    }
                    var6_6 = null;
                }
                catch (AnnotatedException var10_13) {
                    throw new CertPathValidatorException(var10_13.getMessage(), var10_13.getUnderlyingException(), var2_2, var3_3);
                }
                catch (IllegalArgumentException v0) {
                    var6_6 = null;
                }
            } else {
                var6_6 = null;
            }
            if (var7_7 == null) continue;
            try {
                var1_1.verify(var7_7);
            }
            catch (Exception var10_14) {
                var8_8 = var10_14;
                var6_6 = null;
            }
lbl42:
            // 4 sources

        } while (var5_5.hasNext() && var6_6 == null);
        if (var6_6 == null && var8_8 != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate validation failed.", var8_8, var2_2, var3_3);
        }
        return var6_6;
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private X509Principal getEncodedIssuerPrincipal(X509Certificate x509Certificate) throws AnnotatedException {
        try {
            return PrincipalUtil.getIssuerX509Principal(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AnnotatedException("can't get issuer principal.", certificateEncodingException);
        }
    }

    private DERObject getExtensionValue(X509Extension x509Extension, String string) throws AnnotatedException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return this.getObject(string, byArray);
    }

    private X509Principal getIssuerPrincipal(X509CRL x509CRL) throws AnnotatedException {
        try {
            return PrincipalUtil.getIssuerX509Principal(x509CRL);
        }
        catch (CRLException cRLException) {
            throw new AnnotatedException("can't get CRL issuer principal", cRLException);
        }
    }

    private DERObject getObject(String string, byte[] byArray) throws AnnotatedException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new AnnotatedException("exception processing extension " + string, iOException);
        }
    }

    private final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    private X509Principal getSubjectPrincipal(X509Certificate x509Certificate) throws AnnotatedException {
        try {
            return PrincipalUtil.getSubjectX509Principal(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AnnotatedException("can't get subject principal.", certificateEncodingException);
        }
    }

    private Date getValidDate(PKIXParameters pKIXParameters) {
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    private Set intersectDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            if (!this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet.add(aSN1Sequence2);
        }
        return hashSet;
    }

    private Set intersectEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    private Set intersectIP(Set set, byte[] byArray) {
        return set;
    }

    private boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }

    private boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    private boolean processCertD1i(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        int n2 = 0;
        while (n2 < list.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (set2.contains(dERObjectIdentifier.getId())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                listArray[n].add(pKIXPolicyNode2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void processCertD1ii(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        int n2 = 0;
        while (n2 < list.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                listArray[n].add(pKIXPolicyNode2);
                return;
            }
            ++n2;
        }
    }

    private PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            int n = 0;
            while (n < listArray.length) {
                listArray[n] = new ArrayList();
                ++n;
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode pKIXPolicyNode) {
        listArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
            }
        }
    }

    private Set unionDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    private Set unionEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string3);
            hashSet.add(string2);
        }
        return hashSet;
    }

    private Set unionIP(Set set, byte[] byArray) {
        return set;
    }

    private boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        int n = aSN1Sequence2.size() - 1;
        while (n >= 0) {
            if (!aSN1Sequence2.getObjectAt(n).equals(aSN1Sequence.getObjectAt(n))) {
                return false;
            }
            --n;
        }
        return true;
    }
}

