/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mozilla.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.mozilla.PublicKeyAndChallenge;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mozilla.SignedPublicKeyAndChallenge;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class SPKACTest
extends SimpleTest {
    byte[] spkac = Base64.decode("MIIBOjCBpDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApne7ti0ibPhV8Iht7Pws5iRckM7x4mtZYxEpeX5/IO8tDsBFdY86ewuY2f2KCca0oMWr43kdkZbPyzf4CSV+0fZm9MJyNMywygZjoOCC+rS8kr0Ef31iHChhYsyejJnjw116Jnn96syhdHY6lVD1rK0nn5ZkHjxU74gjoZu6BJMCAwEAARYAMA0GCSqGSIb3DQEBBAUAA4GBAKFLg/luv0C7gMTI8ZKfFoSyi7Q7kiSQcmSj1WJgT56ouIRJO5NdvB/1n4GNik8VOAU0NRztvGy3ZGqgbSav7lrxcNEvXH+dLbtS97s7yiaozpsOcEHqsBribpLOTRzYa8ciCwkPmIiYqcby11diKLpd+W9RFYNme2v0rrbM2CyV");

    public String getName() {
        return "SignedPubicKeyAndChallenge";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        SimpleTest.runTest(new SPKACTest());
    }

    public void performTest() throws Exception {
        this.spkacTest("spkac", this.spkac);
    }

    public void spkacTest(String string, byte[] byArray) throws Exception {
        DERIA5String dERIA5String;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        SignedPublicKeyAndChallenge signedPublicKeyAndChallenge = new SignedPublicKeyAndChallenge(byArray);
        PublicKeyAndChallenge publicKeyAndChallenge = signedPublicKeyAndChallenge.getPublicKeyAndChallenge();
        PublicKey publicKey = signedPublicKeyAndChallenge.getPublicKey("BC");
        DERObject dERObject = publicKeyAndChallenge.getDERObject();
        if (dERObject == null) {
            this.fail("Error - " + string + " PKAC DERObject was null.");
        }
        if ((dERObject = signedPublicKeyAndChallenge.getDERObject()) == null) {
            this.fail("Error - " + string + " SPKAC DERObject was null.");
        }
        if ((subjectPublicKeyInfo = publicKeyAndChallenge.getSubjectPublicKeyInfo()) == null) {
            this.fail("Error - " + string + " SubjectPublicKeyInfo was null.");
        }
        if ((dERIA5String = publicKeyAndChallenge.getChallenge()) == null) {
            this.fail(":Error - " + string + " challenge was null.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(signedPublicKeyAndChallenge.getDERObject());
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length != byArray.length) {
            this.fail(String.valueOf(string) + " failed length test");
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray2[n] != byArray[n]) {
                this.fail(String.valueOf(string) + " failed comparison test");
            }
            ++n;
        }
        if (!signedPublicKeyAndChallenge.verify("BC")) {
            this.fail(String.valueOf(string) + " verification failed");
        }
    }
}

