/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.OCSPException;

public class RespID {
    ResponderID id;

    public RespID(PublicKey publicKey) throws OCSPException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            ASN1InputStream aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            messageDigest.update(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            DEROctetString dEROctetString = new DEROctetString(messageDigest.digest());
            this.id = new ResponderID(dEROctetString);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }

    public RespID(ResponderID responderID) {
        this.id = responderID;
    }

    public RespID(X509Principal x509Principal) {
        try {
            this.id = new ResponderID(new X509Principal(x509Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't decode name.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RespID)) {
            return false;
        }
        RespID respID = (RespID)object;
        return this.id.equals(respID.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public ResponderID toASN1Object() {
        return this.id;
    }
}

