/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.extension.jetty;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.extensions.TestSetup;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.cactus.internal.configuration.BaseConfiguration;
import org.apache.cactus.internal.configuration.Configuration;
import org.apache.cactus.internal.configuration.DefaultFilterConfiguration;
import org.apache.cactus.internal.configuration.DefaultServletConfiguration;
import org.apache.cactus.internal.configuration.FilterConfiguration;
import org.apache.cactus.internal.configuration.ServletConfiguration;
import org.apache.cactus.internal.util.ClassLoaderUtils;
import org.apache.cactus.server.FilterTestRedirector;
import org.apache.cactus.server.ServletTestRedirector;

public class Jetty5xTestSetup
extends TestSetup {
    private static final String CACTUS_JETTY_CONFIG_PROPERTY = "cactus.jetty.config";
    private static final String CACTUS_JETTY_RESOURCE_DIR_PROPERTY = "cactus.jetty.resourceDir";
    private File configFile;
    private File resourceDir;
    private Object server;
    private boolean alreadyRunning;
    private boolean isRunning = false;
    private boolean forceShutdown = false;
    private ServletConfiguration servletConfiguration;
    private FilterConfiguration filterConfiguration;
    private Configuration baseConfiguration = new BaseConfiguration();

    public Jetty5xTestSetup(Test theTest) {
        super(theTest);
        this.servletConfiguration = new DefaultServletConfiguration();
        this.filterConfiguration = new DefaultFilterConfiguration();
    }

    public Jetty5xTestSetup(Test theTest, Configuration theBaseConfiguration, ServletConfiguration theServletConfiguration, FilterConfiguration theFilterConfiguration) {
        this(theTest);
        this.baseConfiguration = theBaseConfiguration;
        this.servletConfiguration = theServletConfiguration;
        this.filterConfiguration = theFilterConfiguration;
    }

    public void run(final TestResult theResult) {
        Protectable p = new Protectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void protect() throws Exception {
                try {
                    Jetty5xTestSetup.this.setUp();
                    Jetty5xTestSetup.this.basicRun(theResult);
                }
                finally {
                    Jetty5xTestSetup.this.tearDown();
                }
            }
        };
        theResult.runProtected((Test)this, p);
    }

    protected void setUp() throws Exception {
        URL contextURL = new URL(this.baseConfiguration.getContextURL() + "/" + this.servletConfiguration.getDefaultRedirectorName() + "?Cactus_Service=RUN_TEST");
        this.alreadyRunning = this.isAvailable(this.testConnectivity(contextURL));
        if (this.alreadyRunning) {
            this.isRunning = true;
            return;
        }
        this.server = this.createServer(this.baseConfiguration);
        Object context = this.createContext(this.server, this.baseConfiguration);
        this.addServletRedirector(context, this.servletConfiguration);
        this.addJspRedirector(context);
        this.addFilterRedirector(context, this.filterConfiguration);
        if (this.getConfigFile() != null) {
            this.server.getClass().getMethod("configure", String.class).invoke(this.server, this.getConfigFile().toString());
        }
        this.server.getClass().getMethod("start", null).invoke(this.server, null);
        this.isRunning = true;
    }

    protected void tearDown() throws Exception {
        boolean started;
        if (!this.forceShutdown && this.alreadyRunning) {
            return;
        }
        if (this.server != null && (started = ((Boolean)this.server.getClass().getMethod("isStarted", null).invoke(this.server, null)).booleanValue())) {
            this.server.getClass().getMethod("stop", null).invoke(this.server, null);
            this.server.getClass().getMethod("destroy", null).invoke(this.server, null);
        }
        this.isRunning = false;
    }

    public final void setConfigFile(File theConfigFile) {
        this.configFile = theConfigFile;
    }

    public final void setResourceDir(File theResourceDir) {
        this.resourceDir = theResourceDir;
    }

    public final void setForceShutdown(boolean isForcedShutdown) {
        this.forceShutdown = isForcedShutdown;
    }

    protected final File getConfigFile() {
        String configFileProperty;
        if (this.configFile == null && (configFileProperty = System.getProperty(CACTUS_JETTY_CONFIG_PROPERTY)) != null) {
            this.configFile = new File(configFileProperty);
        }
        return this.configFile;
    }

    protected final File getResourceDir() {
        String resourceDirProperty;
        if (this.resourceDir == null && (resourceDirProperty = System.getProperty(CACTUS_JETTY_RESOURCE_DIR_PROPERTY)) != null) {
            this.resourceDir = new File(resourceDirProperty);
        }
        return this.resourceDir;
    }

    private Object createServer(Configuration theConfiguration) throws Exception {
        Class serverClass = ClassLoaderUtils.loadClass("org.mortbay.jetty.Server", ((Object)((Object)this)).getClass());
        Object server = serverClass.newInstance();
        URL contextURL = new URL(theConfiguration.getContextURL());
        server.getClass().getMethod("addListener", String.class).invoke(server, "" + contextURL.getPort());
        return server;
    }

    private Object createContext(Object theServer, Configuration theConfiguration) throws Exception {
        URL contextURL = new URL(theConfiguration.getContextURL());
        if (this.getResourceDir() != null) {
            theServer.getClass().getMethod("addWebApplication", String.class, String.class).invoke(theServer, contextURL.getPath(), this.getResourceDir().toString());
        }
        Object context = theServer.getClass().getMethod("getContext", String.class).invoke(theServer, contextURL.getPath());
        return context;
    }

    private void addServletRedirector(Object theContext, ServletConfiguration theConfiguration) throws Exception {
        theContext.getClass().getMethod("addServlet", String.class, String.class, String.class).invoke(theContext, theConfiguration.getDefaultRedirectorName(), "/" + theConfiguration.getDefaultRedirectorName(), ServletTestRedirector.class.getName());
    }

    private void addJspRedirector(Object theContext) throws Exception {
        if (this.getResourceDir() != null) {
            theContext.getClass().getMethod("addServlet", String.class, String.class).invoke(theContext, "*.jsp", "org.apache.jasper.servlet.JspServlet");
            Object handler = theContext.getClass().getMethod("getWebApplicationHandler", new Class[0]).invoke(theContext, new Object[0]);
            handler.getClass().getMethod("addServlet", String.class, String.class, String.class, String.class).invoke(handler, "JspRedirector", "/JspRedirector", "org.apache.jasper.servlet.JspServlet", "/jspRedirector.jsp");
        }
    }

    private void addFilterRedirector(Object theContext, FilterConfiguration theConfiguration) throws Exception {
        if (this.getResourceDir() != null) {
            Object handler = theContext.getClass().getMethod("getWebApplicationHandler", new Class[0]).invoke(theContext, new Object[0]);
            Object filterHolder = handler.getClass().getMethod("defineFilter", String.class, String.class).invoke(handler, theConfiguration.getDefaultRedirectorName(), FilterTestRedirector.class.getName());
            handler.getClass().getMethod("addFilterPathMapping", String.class, String.class, Integer.TYPE).invoke(handler, "/" + theConfiguration.getDefaultRedirectorName(), theConfiguration.getDefaultRedirectorName(), new Integer(0));
        }
    }

    protected int testConnectivity(URL theUrl) {
        int code;
        try {
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            connection.setRequestProperty("Connection", "close");
            connection.connect();
            this.readFully(connection);
            connection.disconnect();
            code = connection.getResponseCode();
        }
        catch (IOException e) {
            code = -1;
        }
        return code;
    }

    protected boolean isAvailable(int theCode) {
        boolean result = theCode != -1 && theCode < 300;
        return result;
    }

    protected void readFully(HttpURLConnection theConnection) throws IOException {
        if (theConnection.getContentLength() != 0) {
            byte[] buf = new byte[256];
            InputStream in = theConnection.getInputStream();
            while (in.read(buf) != -1) {
            }
        }
    }

    protected boolean isRunning() {
        return this.isRunning;
    }
}

