/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.cactus.Request;
import org.apache.cactus.internal.client.ClientException;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.internal.util.TestCaseImplementChecker;
import org.apache.cactus.spi.client.ResponseObjectFactory;
import org.apache.cactus.spi.client.connector.ProtocolHandler;
import org.apache.cactus.spi.client.connector.ProtocolState;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ClientTestCaseCaller
extends Assert {
    protected static final String TEST_METHOD_PREFIX = "test";
    protected static final String BEGIN_METHOD_PREFIX = "begin";
    protected static final String END_METHOD_PREFIX = "end";
    protected static final String CLIENT_GLOBAL_BEGIN_METHOD = "begin";
    protected static final String CLIENT_GLOBAL_END_METHOD = "end";
    private Log logger;
    private Test wrappedTest;
    private Test delegatedTest;
    private ProtocolHandler protocolHandler;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ClientTestCaseCaller(Test theDelegatedTest, Test theWrappedTest, ProtocolHandler theProtocolHandler) {
        if (theDelegatedTest == null) {
            throw new IllegalStateException("The test object passed must not be null");
        }
        this.setDelegatedTest(theDelegatedTest);
        this.setWrappedTest(theWrappedTest);
        this.protocolHandler = theProtocolHandler;
    }

    public void runTest() throws Throwable {
        Request request = this.protocolHandler.createRequest();
        this.callGlobalBeginMethod(request);
        this.callBeginMethod(request);
        ProtocolState state = this.protocolHandler.runTest(this.getDelegatedTest(), this.getWrappedTest(), request);
        Object response = this.callEndMethod(request, this.protocolHandler.createResponseObjectFactory(state));
        this.callGlobalEndMethod(request, this.protocolHandler.createResponseObjectFactory(state), response);
        this.protocolHandler.afterTest(state);
    }

    public final Log getLogger() {
        return this.logger;
    }

    public void runBareInit() {
        this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.getLogger().debug((Object)("------------- Test: " + this.getCurrentTestName()));
    }

    public void callBeginMethod(Request request) throws Throwable {
        Request request2 = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)request2);
        ClientTestCaseCaller.callBeginMethod_aroundBody1$advice(this, request2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public Object callEndMethod(Request request, ResponseObjectFactory responseObjectFactory) throws Throwable {
        Request request2 = request;
        ResponseObjectFactory responseObjectFactory2 = responseObjectFactory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)request2, (Object)responseObjectFactory2);
        return ClientTestCaseCaller.callEndMethod_aroundBody3$advice(this, request2, responseObjectFactory2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void callGlobalBeginMethod(Request request) throws Throwable {
        Request request2 = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)request2);
        ClientTestCaseCaller.callGlobalBeginMethod_aroundBody5$advice(this, request2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private void callGlobalEndMethod(Request theRequest, ResponseObjectFactory theResponseFactory, Object theResponse) throws Throwable {
        this.callGenericEndMethod(theRequest, theResponseFactory, "end", theResponse);
    }

    private void setWrappedTest(Test theWrappedTest) {
        this.wrappedTest = theWrappedTest;
    }

    private void setDelegatedTest(Test theDelegatedTest) {
        this.delegatedTest = theDelegatedTest;
    }

    private Test getWrappedTest() {
        return this.wrappedTest;
    }

    private Test getDelegatedTest() {
        return this.delegatedTest;
    }

    private Test getTest() {
        Test activeTest = this.getWrappedTest() != null ? this.getWrappedTest() : this.getDelegatedTest();
        return activeTest;
    }

    private String getBaseMethodName() {
        if (!this.getCurrentTestName().startsWith(TEST_METHOD_PREFIX)) {
            throw new RuntimeException("bad name [" + this.getCurrentTestName() + "]. It should start with [" + TEST_METHOD_PREFIX + "].");
        }
        return this.getCurrentTestName().substring(TEST_METHOD_PREFIX.length());
    }

    private String getBeginMethodName() {
        return "begin" + this.getBaseMethodName();
    }

    private String getEndMethodName() {
        return "end" + this.getBaseMethodName();
    }

    private void callGenericBeginMethod(Request theRequest, String theMethodName) throws Throwable {
        Method[] methods = this.getTest().getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(theMethodName)) {
                TestCaseImplementChecker.checkAsBeginMethod(methods[i]);
                try {
                    methods[i].invoke((Object)this.getTest(), theRequest);
                    break;
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throw e;
                }
            }
            ++i;
        }
    }

    private Object callGenericEndMethod(Request theRequest, ResponseObjectFactory theResponseFactory, String theMethodName, Object theResponse) throws Throwable {
        Method methodToCall = null;
        Object paramObject = null;
        Method[] methods = this.getTest().getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(theMethodName)) {
                TestCaseImplementChecker.checkAsEndMethod(methods[i]);
                paramObject = theResponse;
                if (paramObject == null) {
                    Class<?>[] parameters = methods[i].getParameterTypes();
                    try {
                        paramObject = theResponseFactory.getResponseObject(parameters[0].getName(), theRequest);
                    }
                    catch (ClientException e) {
                        throw new ClientException("The method [" + methods[i].getName() + "] has a bad parameter of type [" + parameters[0].getName() + "]", e);
                    }
                }
                if (methodToCall != null) {
                    ClientTestCaseCaller.fail((String)("There can only be one method [" + methods[i].getName() + "] per test case. " + "Test case [" + this.getCurrentTestName() + "] has two at least !"));
                }
                methodToCall = methods[i];
            }
            ++i;
        }
        if (methodToCall != null) {
            try {
                methodToCall.invoke((Object)this.getTest(), paramObject);
            }
            catch (InvocationTargetException e) {
                e.fillInStackTrace();
                throw e.getTargetException();
            }
            catch (IllegalAccessException e) {
                e.fillInStackTrace();
                throw e;
            }
        }
        return paramObject;
    }

    private String getCurrentTestName() {
        return JUnitVersionHelper.getTestCaseName(this.getDelegatedTest());
    }

    static {
        Factory factory = new Factory("ClientTestCaseCaller.java", Class.forName("org.apache.cactus.internal.client.ClientTestCaseCaller"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-callBeginMethod-org.apache.cactus.internal.client.ClientTestCaseCaller-org.apache.cactus.Request:-theRequest:-java.lang.Throwable:-void-"), 191);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-callEndMethod-org.apache.cactus.internal.client.ClientTestCaseCaller-org.apache.cactus.Request:org.apache.cactus.spi.client.ResponseObjectFactory:-theRequest:theResponseFactory:-java.lang.Throwable:-java.lang.Object-"), 206);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-callGlobalBeginMethod-org.apache.cactus.internal.client.ClientTestCaseCaller-org.apache.cactus.Request:-theRequest:-java.lang.Throwable:-void-"), 221);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object callBeginMethod_aroundBody1$advice(ClientTestCaseCaller this_, Request ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            this_.callGenericBeginMethod(ajc_aroundClosure, this_.getBeginMethodName());
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        this_.callGenericBeginMethod(ajc_aroundClosure, this_.getBeginMethodName());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object callEndMethod_aroundBody3$advice(ClientTestCaseCaller this_, Request ajc_aroundClosure, ResponseObjectFactory thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            Object object = this_.callGenericEndMethod(ajc_aroundClosure, thisJoinPoint, this_.getEndMethodName(), null);
            StringBuffer stringBuffer = new StringBuffer(joinPoint2.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(object);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return object;
        }
        AroundClosure aroundClosure3 = aroundClosure;
        return this_.callGenericEndMethod(ajc_aroundClosure, thisJoinPoint, this_.getEndMethodName(), null);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object callGlobalBeginMethod_aroundBody5$advice(ClientTestCaseCaller this_, Request ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            this_.callGenericBeginMethod(ajc_aroundClosure, "begin");
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        this_.callGenericBeginMethod(ajc_aroundClosure, "begin");
        return null;
    }
}

