/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.internal.util.TestCaseImplementError;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public final class TestCaseImplementChecker {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    private TestCaseImplementChecker() {
    }

    public static void checkTestName(Test test) throws TestCaseImplementError {
        Test test2 = test;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)test2);
        TestCaseImplementChecker.checkTestName_aroundBody1$advice(test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private static String numeric(int theNum) {
        switch (theNum) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return String.valueOf(theNum) + "th";
    }

    private static void checkReturnType(Method theMethod, Class theType) throws TestCaseImplementError {
        if (!theMethod.getReturnType().equals(theType)) {
            throw new TestCaseImplementError("The method [" + theMethod.getName() + "] should return " + theType + " and not [" + theMethod.getReturnType().getName() + "]");
        }
    }

    private static void isPublic(Method theMethod) throws TestCaseImplementError {
        if (!Modifier.isPublic(theMethod.getModifiers())) {
            throw new TestCaseImplementError("The method [" + theMethod.getName() + "] should be declared public");
        }
    }

    private static void checkParameterCount(Method theMethod, Class[] theParams) throws TestCaseImplementError {
        Class<?>[] parameters = theMethod.getParameterTypes();
        if (parameters.length != theParams.length) {
            throw new TestCaseImplementError("The method [" + theMethod.getName() + "] must have " + theParams.length + " parameter(s), " + "but " + parameters.length + " parameter(s) were found");
        }
    }

    private static void checkParameterTypes(Method theMethod, Class[] theParams) throws TestCaseImplementError {
        TestCaseImplementChecker.checkParameterCount(theMethod, theParams);
        Class<?>[] parameters = theMethod.getParameterTypes();
        int i = 0;
        while (i < parameters.length) {
            Class expected = theParams[i];
            Class<?> actual = parameters[i];
            if (!expected.isAssignableFrom(actual)) {
                throw new TestCaseImplementError("The method [" + theMethod.getName() + "] must accept [" + expected.getName() + "] as " + TestCaseImplementChecker.numeric(i + 1) + " parameter, but found a [" + actual.getName() + "] parameter instead");
            }
            ++i;
        }
    }

    private static void checkAsCactusMethod(Method theMethod) throws TestCaseImplementError {
        TestCaseImplementChecker.checkReturnType(theMethod, Void.TYPE);
        TestCaseImplementChecker.isPublic(theMethod);
    }

    public static void checkAsBeginMethod(Method method) throws TestCaseImplementError {
        Method method2 = method;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)method2);
        TestCaseImplementChecker.checkAsBeginMethod_aroundBody3$advice(method2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public static void checkAsEndMethod(Method method) throws TestCaseImplementError {
        Method method2 = method;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)method2);
        TestCaseImplementChecker.checkAsEndMethod_aroundBody5$advice(method2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    static {
        Factory factory = new Factory("TestCaseImplementChecker.java", Class.forName("org.apache.cactus.internal.util.TestCaseImplementChecker"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-checkTestName-org.apache.cactus.internal.util.TestCaseImplementChecker-junit.framework.Test:-theTest:-org.apache.cactus.internal.util.TestCaseImplementError:-void-"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-checkAsBeginMethod-org.apache.cactus.internal.util.TestCaseImplementChecker-java.lang.reflect.Method:-theMethod:-org.apache.cactus.internal.util.TestCaseImplementError:-void-"), 188);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-checkAsEndMethod-org.apache.cactus.internal.util.TestCaseImplementChecker-java.lang.reflect.Method:-theMethod:-org.apache.cactus.internal.util.TestCaseImplementError:-void-"), 208);
    }

    private static final /* synthetic */ void checkTestName_aroundBody0(Test theTest, JoinPoint joinPoint) {
        if (theTest == null) {
            return;
        }
        if (JUnitVersionHelper.getTestCaseName(theTest) == null) {
            throw new TestCaseImplementError("No test name found. The test [" + theTest.getClass().getName() + "] is not properly implemented.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object checkTestName_aroundBody1$advice(Test this_, JoinPoint ajc_aroundClosure, LogAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Log log = LogFactory.getLog((Class)joinPoint.getSignature().getDeclaringType());
        if (log.isDebugEnabled()) {
            void result;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(thisJoinPoint, joinPoint)));
            void var7_6 = logger;
            TestCaseImplementChecker.checkTestName_aroundBody0(this_, ajc_aroundClosure);
            Object var6_7 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var6_7;
        }
        void var8_8 = logger;
        TestCaseImplementChecker.checkTestName_aroundBody0(this_, ajc_aroundClosure);
        return null;
    }

    private static final /* synthetic */ void checkAsBeginMethod_aroundBody2(Method theMethod, JoinPoint joinPoint) {
        TestCaseImplementChecker.checkAsCactusMethod(theMethod);
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.Request");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        TestCaseImplementChecker.checkParameterTypes(theMethod, classArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object checkAsBeginMethod_aroundBody3$advice(Method this_, JoinPoint ajc_aroundClosure, LogAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Log log = LogFactory.getLog((Class)joinPoint.getSignature().getDeclaringType());
        if (log.isDebugEnabled()) {
            void result;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(thisJoinPoint, joinPoint)));
            void var7_6 = logger;
            TestCaseImplementChecker.checkAsBeginMethod_aroundBody2(this_, ajc_aroundClosure);
            Object var6_7 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var6_7;
        }
        void var8_8 = logger;
        TestCaseImplementChecker.checkAsBeginMethod_aroundBody2(this_, ajc_aroundClosure);
        return null;
    }

    private static final /* synthetic */ void checkAsEndMethod_aroundBody4(Method theMethod, JoinPoint joinPoint) {
        TestCaseImplementChecker.checkAsCactusMethod(theMethod);
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        TestCaseImplementChecker.checkParameterCount(theMethod, classArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object checkAsEndMethod_aroundBody5$advice(Method this_, JoinPoint ajc_aroundClosure, LogAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Log log = LogFactory.getLog((Class)joinPoint.getSignature().getDeclaringType());
        if (log.isDebugEnabled()) {
            void result;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(thisJoinPoint, joinPoint)));
            void var7_6 = logger;
            TestCaseImplementChecker.checkAsEndMethod_aroundBody4(this_, ajc_aroundClosure);
            Object var6_7 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var6_7;
        }
        void var8_8 = logger;
        TestCaseImplementChecker.checkAsEndMethod_aroundBody4(this_, ajc_aroundClosure);
        return null;
    }
}

