/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.cactus.integration.api.cactify.FilterRedirector;
import org.apache.cactus.integration.api.cactify.JspRedirector;
import org.apache.cactus.integration.api.cactify.Redirector;
import org.apache.cactus.integration.api.cactify.ServletRedirector;
import org.apache.cactus.integration.api.version.Version;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.War;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.ZipFileSet;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.EjbRef;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.module.webapp.merge.WebXmlMerger;
import org.codehaus.cargo.util.log.AntLogger;
import org.codehaus.cargo.util.log.Logger;
import org.jdom.JDOMException;
import org.xml.sax.EntityResolver;

public class CactifyWarTask
extends War {
    private String context;
    private String FILE_NAME = "cactus.war";
    private static Random rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
    private static final String FILTER_REDIRECTOR_CLASS = "org.apache.cactus.server.FilterTestRedirector";
    private static final String DEFAULT_FILTER_REDIRECTOR_MAPPING = "/FilterRedirector";
    private static final String DEFAULT_JSP_REDIRECTOR_MAPPING = "/JspRedirector";
    private static final String SERVLET_REDIRECTOR_CLASS = "org.apache.cactus.server.ServletTestRedirector";
    private static final String DEFAULT_SERVLET_REDIRECTOR_MAPPING = "/ServletRedirector";
    private File srcFile;
    private File mergeWebXml;
    private List redirectors = new ArrayList();
    private XMLCatalog xmlCatalog = null;
    private String version = null;
    private List ejbRefs = new ArrayList();
    private ResourceUtils utils = new ResourceUtils();
    private boolean includeCactusJars = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        WebXml webXml = null;
        if (this.srcFile != null) {
            this.log("Analyzing war: " + this.srcFile.getAbsolutePath(), 2);
            ZipFileSet currentFiles = new ZipFileSet();
            currentFiles.setSrc(this.srcFile);
            currentFiles.createExclude().setName("WEB-INF/web.xml");
            currentFiles.createExclude().setName("WEB-INF/weblogic.xml");
            currentFiles.createExclude().setName("WEB-INF/orion-web.xml");
            currentFiles.createExclude().setName("WEB-INF/ibm-web-bnd.xmi");
            this.addZipfileset(currentFiles);
            try {
                webXml = this.getOriginalWebXml();
            }
            catch (JDOMException e) {
                throw new BuildException("Unable to get the original exception", (Throwable)e);
            }
        }
        if (this.srcFile == null || webXml == null) {
            if (this.version == null) {
                throw new BuildException("You need to specify either the [srcfile] or the [version] attribute");
            }
            WebXmlVersion webXmlVersion = null;
            webXmlVersion = this.version.equals("2.2") ? WebXmlVersion.V2_2 : (this.version.equals("2.3") ? WebXmlVersion.V2_3 : WebXmlVersion.V2_4);
            webXml = WebXmlIo.newWebXml((WebXmlVersion)webXmlVersion);
        }
        File tmpWebXml = null;
        try {
            tmpWebXml = this.cactifyWebXml(webXml);
        }
        catch (JDOMException e) {
            throw new BuildException("Unable to cactify your application.", (Throwable)e);
        }
        this.setWebxml(tmpWebXml);
        if (this.includeCactusJars) {
            this.addCactusJars();
        }
        try {
            super.execute();
        }
        finally {
            tmpWebXml.delete();
        }
    }

    public final void addFilterRedirector(FilterRedirector theFilterRedirector) {
        this.redirectors.add(theFilterRedirector);
    }

    public final void addJspRedirector(JspRedirector theJspRedirector) {
        this.redirectors.add(theJspRedirector);
    }

    public final void addServletRedirector(ServletRedirector theServletRedirector) {
        this.redirectors.add(theServletRedirector);
    }

    public final void addConfiguredXMLCatalog(XMLCatalog theXmlCatalog) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(theXmlCatalog);
    }

    public final void addConfiguredEjbref(EjbRef theEjbRef) {
        this.ejbRefs.add(theEjbRef);
    }

    public final void setMergeWebXml(File theMergeFile) {
        this.mergeWebXml = theMergeFile;
    }

    public final void setSrcFile(File theSrcFile) {
        this.srcFile = theSrcFile;
    }

    public final void setVersion(Version theVersion) {
        this.version = theVersion.getValue();
    }

    public final void setIncludeCactusJars(boolean includeCactusJars) {
        this.includeCactusJars = includeCactusJars;
    }

    private void addCactusJars() {
        this.addJarWithClass("org.aspectj.lang.JoinPoint", "AspectJ Runtime");
        this.addJarWithClass("org.apache.cactus.ServletTestCase", "Cactus Framework");
        this.addJarWithClass("org.apache.commons.logging.Log", "Commons-Logging");
        this.addJarWithClass("org.apache.commons.httpclient.HttpClient", "Commons-HttpClient");
        this.addJarWithClass("junit.framework.TestCase", "JUnit");
    }

    private void addJarWithClass(String theClassName, String theDescription) {
        String resourceName = "/" + theClassName.replace('.', '/') + ".class";
        if (this.srcFile != null) {
            try {
                DefaultWarArchive srcWar = new DefaultWarArchive((InputStream)new FileInputStream(this.srcFile));
                if (srcWar.containsClass(theClassName)) {
                    this.log("The " + theDescription + " JAR is already present in " + "the WAR", 3);
                    return;
                }
            }
            catch (IOException ioe) {
                this.log("Problem reading source WAR to when trying to detect already present JAR files (" + ioe + ")", 1);
            }
        }
        ZipFileSet jar = new ZipFileSet();
        File file = this.utils.getResourceLocation(resourceName);
        if (file != null) {
            jar.setFile(file);
            this.addLib(jar);
        } else {
            this.log("Could not find the " + theDescription + " JAR", 1);
            this.log("You need to add the JAR to the classpath of the task", 2);
            this.log("(Searched for class " + theClassName + ")", 4);
        }
    }

    private void addJspRedirector() {
        File jspRedirectorFile = new File(new File(System.getProperty("java.io.tmpdir")), "jspRedirector.jsp");
        jspRedirectorFile.deleteOnExit();
        try {
            this.utils.copyResource("/org/apache/cactus/server/jspRedirector.jsp", jspRedirectorFile);
        }
        catch (IOException e) {
            this.log("Could not copy the JSP redirector (" + e.getMessage() + ")", 1);
        }
        FileSet fileSet = new FileSet();
        fileSet.setFile(jspRedirectorFile);
        this.addFileset(fileSet);
    }

    private void addRedirectorDefinitions(WebXml theWebXml) {
        boolean filterRedirectorDefined = false;
        boolean jspRedirectorDefined = false;
        boolean servletRedirectorDefined = false;
        Iterator i = this.redirectors.iterator();
        while (i.hasNext()) {
            Redirector redirector = (Redirector)i.next();
            if (redirector instanceof FilterRedirector) {
                filterRedirectorDefined = true;
            } else if (redirector instanceof JspRedirector) {
                jspRedirectorDefined = true;
            } else if (redirector instanceof ServletRedirector) {
                servletRedirectorDefined = true;
            }
            redirector.mergeInto(theWebXml);
        }
        if (!filterRedirectorDefined) {
            new FilterRedirector((Logger)new AntLogger(this.getProject())).mergeInto(theWebXml);
        }
        if (!servletRedirectorDefined) {
            new ServletRedirector((Logger)new AntLogger(this.getProject())).mergeInto(theWebXml);
        }
        if (!jspRedirectorDefined) {
            new JspRedirector((Logger)new AntLogger(this.getProject())).mergeInto(theWebXml);
        }
    }

    private File cactifyWebXml(WebXml theWebXml) throws JDOMException {
        this.addRedirectorDefinitions(theWebXml);
        this.addJspRedirector();
        this.addEjbRefs(theWebXml);
        if (this.mergeWebXml != null) {
            try {
                WebXml parsedMergeWebXml = WebXmlIo.parseWebXmlFromFile((File)this.mergeWebXml, (EntityResolver)this.xmlCatalog);
                WebXmlMerger merger = new WebXmlMerger((Descriptor)theWebXml);
                merger.setLogger((Logger)new AntLogger((Task)this));
                merger.merge((Descriptor)parsedMergeWebXml);
            }
            catch (IOException e) {
                throw new BuildException("Could not merge deployment descriptors", (Throwable)e);
            }
        }
        File tmpDir = this.createTempFile("cactus", "tmp.dir", this.getProject().getBaseDir(), true);
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        File webXmlFile = null;
        try {
            ZipFileSet fileSet = new ZipFileSet();
            fileSet.setDir(tmpDir);
            tmpDir.mkdir();
            File[] files = WebXmlIo.writeAll((J2eeDescriptor)theWebXml, (String)tmpDir.getAbsolutePath());
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                f.deleteOnExit();
                if (f.getName().equals("web.xml")) {
                    webXmlFile = f;
                    continue;
                }
                fileSet.createInclude().setName(f.getName());
            }
            this.addWebinf(fileSet);
        }
        catch (IOException ioe) {
            throw new BuildException("Could not write temporary deployment descriptor", (Throwable)ioe);
        }
        return webXmlFile;
    }

    private WebXml getOriginalWebXml() throws BuildException, JDOMException {
        DefaultWarArchive war = null;
        try {
            war = new DefaultWarArchive((InputStream)new FileInputStream(this.srcFile));
            WebXml webXml = war.getWebXml();
            return webXml;
        }
        catch (IOException e) {
            throw new BuildException("Failed to open WAR", (Throwable)e);
        }
    }

    private void addEjbRefs(WebXml theWebXml) {
        Iterator i = this.ejbRefs.iterator();
        while (i.hasNext()) {
            EjbRef ref = (EjbRef)i.next();
            WebXmlUtils.addEjbRef((WebXml)theWebXml, (EjbRef)ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String thePrefix, String theSuffix, File theParentDir, boolean isDeleteOnExit) {
        File result = null;
        String parent = theParentDir == null ? System.getProperty("java.io.tmpdir") : theParentDir.getPath();
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((result = new File(parent, thePrefix + fmt.format(Math.abs(rand.nextInt())) + theSuffix)).exists()) {
            }
        }
        if (isDeleteOnExit) {
            result.deleteOnExit();
        }
        return result;
    }

    public String getFileName() {
        return this.FILE_NAME;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}

