/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.cactus.container.ContainerRunner;
import org.apache.cactus.container.ContainerWrapper;
import org.apache.cactus.integration.ant.CargoElement;
import org.apache.cactus.integration.ant.ContainerSet;
import org.apache.cactus.integration.ant.util.PropertySet;
import org.apache.cactus.integration.api.deployable.DeployableFile;
import org.apache.cactus.integration.api.deployable.EarParser;
import org.apache.cactus.integration.api.deployable.WarParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.util.log.AntLogger;
import org.codehaus.cargo.util.log.Logger;

public class CactusTask
extends JUnitTask {
    private ContainerSet containerSet;
    private File earFile;
    private File warFile;
    private Map systemProperties = new HashMap();
    private Path containerClasspath;

    public void init() {
        super.init();
        this.addClasspathEntry("/org/aspectj/lang/JoinPoint.class");
        this.addClasspathEntry("/org/apache/cactus/ServletTestCase.class");
        this.addClasspathEntry("/org/apache/cactus/integration/ant/CactusTask.class");
        this.addClasspathEntry("/org/apache/commons/logging/Log.class");
        this.addClasspathEntry("/org/apache/commons/httpclient/HttpClient.class");
    }

    public void execute() throws BuildException {
        if (this.warFile == null && this.earFile == null) {
            throw new BuildException("You must specify either the [warfile] or the [earfile] attribute");
        }
        if (this.warFile != null && this.earFile != null) {
            throw new BuildException("You must specify either the [warfile] or the [earfile] attribute but not both");
        }
        Object deployableFile = this.warFile != null ? WarParser.parse((File)this.warFile) : EarParser.parse((File)this.earFile);
        this.addRedirectorNameProperties((DeployableFile)deployableFile);
        if (this.containerSet == null || this.containerSet.getCargos() == null) {
            this.log("No cargo configurations specified, tests will run locally", 3);
            super.execute();
        } else {
            CargoElement[] cargoElements = this.containerSet.getCargos();
            Environment.Variable contextUrl = new Environment.Variable();
            contextUrl.setKey("cactus.contextURL");
            this.addSysproperty(contextUrl);
            for (int i = 0; i < cargoElements.length; ++i) {
                CargoElement element = cargoElements[i];
                Container container = element.getCargoContainer();
                ContainerWrapper wrapper = new ContainerWrapper(container);
                wrapper.setLogger((Logger)new AntLogger((Task)this));
                DeployableFile thisDeployable = null;
                try {
                    thisDeployable = (DeployableFile)deployableFile.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new BuildException((Throwable)e);
                }
                wrapper.setSystemProperties(this.systemProperties);
                if (this.containerClasspath != null) {
                    wrapper.setContainerClasspath(this.containerClasspath.list());
                }
                if (!wrapper.isEnabled()) continue;
                wrapper.init();
                this.log("-----------------------------------------------------------------", 2);
                this.log("Running tests against " + wrapper.getName() + " @ " + wrapper.getBaseURL(), 2);
                this.log("-----------------------------------------------------------------", 2);
                contextUrl.setValue(wrapper.getBaseURL() + "/" + thisDeployable.getTestContext());
                this.executeInContainer(wrapper, thisDeployable);
            }
        }
    }

    public final void addContainerSet(ContainerSet theContainerSet) {
        if (this.containerSet != null) {
            throw new BuildException("Only one nested containerset element supported");
        }
        this.containerSet = theContainerSet;
    }

    public final void setEarFile(File theEarFile) {
        if (this.warFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.earFile = theEarFile;
    }

    public final void setWarFile(File theWarFile) {
        if (this.earFile != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.warFile = theWarFile;
    }

    public void addSysproperty(Environment.Variable theProperty) {
        this.addCactusServerProperty(theProperty);
        if (theProperty.getKey() != null && !theProperty.getKey().trim().equals("") && theProperty.getValue() != null && !theProperty.getValue().trim().equals("")) {
            this.addCactusClientProperty(theProperty.getKey(), theProperty.getValue());
        }
        super.addSysproperty(theProperty);
    }

    public void addConfiguredSysproperty(Environment.Variable theProperty) {
        this.addSysproperty(theProperty);
    }

    public void addConfiguredCactusproperty(PropertySet thePropertySet) {
        ResourceBundle bundle = thePropertySet.readProperties();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Environment.Variable var = new Environment.Variable();
            var.setKey(key);
            var.setValue(bundle.getString(key));
            if (thePropertySet.isServer()) {
                this.addCactusServerProperty(var);
                continue;
            }
            super.addSysproperty(var);
        }
    }

    public Path createContainerClasspath() {
        if (this.containerClasspath == null) {
            this.containerClasspath = new Path(this.project);
        }
        return this.containerClasspath.createPath();
    }

    private void addCactusClientProperty(String theKey, String theValue) {
        this.log("Adding Cactus client system property [" + theKey + "] with value [" + theValue + "]", 3);
        Environment.Variable sysProperty = new Environment.Variable();
        sysProperty.setKey(theKey);
        sysProperty.setValue(theValue);
        super.addSysproperty(sysProperty);
    }

    private void addCactusServerProperty(Environment.Variable theProperty) {
        if (theProperty.getKey() == null || theProperty.getKey().trim().equals("") || theProperty.getValue() == null || theProperty.getValue().trim().equals("")) {
            return;
        }
        this.log("Adding Cactus server system property [" + theProperty.getKey() + "] with value [" + theProperty.getValue() + "]", 3);
        this.systemProperties.put(theProperty.getKey(), theProperty.getValue());
    }

    private void addCactusServerProperty(String theKey, String theValue) {
        Environment.Variable property = new Environment.Variable();
        property.setKey(theKey);
        property.setValue(theValue);
        this.addCactusServerProperty(property);
    }

    private void addRedirectorNameProperties(DeployableFile theFile) {
        String filterRedirectorMapping = theFile.getFilterRedirectorMapping();
        if (filterRedirectorMapping != null) {
            this.addCactusClientProperty("cactus.filterRedirectorName", filterRedirectorMapping.substring(1));
        } else {
            this.log("No mapping of the filter redirector found", 3);
        }
        String jspRedirectorMapping = theFile.getJspRedirectorMapping();
        if (jspRedirectorMapping != null) {
            this.addCactusClientProperty("cactus.jspRedirectorName", jspRedirectorMapping.substring(1));
        } else {
            this.log("No mapping of the JSP redirector found", 3);
        }
        String servletRedirectorMapping = theFile.getServletRedirectorMapping();
        if (servletRedirectorMapping == null) {
            throw new BuildException("The WAR has not been cactified");
        }
        this.addCactusClientProperty("cactus.servletRedirectorName", servletRedirectorMapping.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInContainer(ContainerWrapper theWrapper, DeployableFile theFile) {
        super.init();
        this.log("Starting up container", 3);
        ContainerRunner runner = new ContainerRunner(theWrapper);
        runner.setLogger((Logger)new AntLogger(this.getProject()));
        try {
            URL url = new URL(theWrapper.getBaseURL() + "/" + theFile.getTestContext() + theFile.getServletRedirectorMapping() + "?Cactus_Service=RUN_TEST");
            runner.setURL(url);
            runner.startUpContainer();
            this.log("Server name retrieved from 'Server' HTTP header: [" + runner.getServerName() + "]", 3);
            try {
                Enumeration tests = this.getIndividualTests();
                while (tests.hasMoreElements()) {
                    JUnitTest test = (JUnitTest)tests.nextElement();
                    if (!test.shouldRun(this.getProject()) || theWrapper.isExcluded(test.getName())) continue;
                    test.setFork(true);
                    if (theWrapper.getToDir() != null) {
                        test.setTodir(theWrapper.getToDir());
                    }
                    this.execute(test);
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.log("Shutting down container", 3);
                runner.shutDownContainer();
                this.log("Container shut down", 3);
                throw throwable;
            }
            this.log("Shutting down container", 3);
            runner.shutDownContainer();
            this.log("Container shut down", 3);
            {
            }
        }
        catch (MalformedURLException mue) {
            throw new BuildException("Malformed test URL", (Throwable)mue);
        }
    }
}

