/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.api.cactify;

import java.util.Iterator;
import java.util.List;
import org.apache.cactus.integration.api.cactify.FilterRedirector;
import org.apache.cactus.integration.api.cactify.JspRedirector;
import org.apache.cactus.integration.api.cactify.Redirector;
import org.apache.cactus.integration.api.cactify.ServletRedirector;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.util.log.Logger;

public class CactifyUtils {
    private ResourceUtils utils = new ResourceUtils();
    private Logger logger;

    public void debug(String msg) {
        this.getLogger().debug(msg, this.getClass().getName());
    }

    public void info(String msg) {
        this.getLogger().info(msg, this.getClass().getName());
    }

    public void warn(String msg) {
        this.getLogger().warn(msg, this.getClass().getName());
    }

    public void addRedirectorDefinitions(WebXml theWebXml, List redirectors) {
        boolean filterRedirectorDefined = false;
        boolean jspRedirectorDefined = false;
        boolean servletRedirectorDefined = false;
        Iterator i = redirectors.iterator();
        while (i.hasNext()) {
            Redirector redirector = (Redirector)i.next();
            if (redirector instanceof FilterRedirector) {
                filterRedirectorDefined = true;
            } else if (redirector instanceof JspRedirector) {
                jspRedirectorDefined = true;
            } else if (redirector instanceof ServletRedirector) {
                servletRedirectorDefined = true;
            }
            redirector.mergeInto(theWebXml);
        }
        if (!filterRedirectorDefined) {
            new FilterRedirector(this.getLogger()).mergeInto(theWebXml);
        }
        if (!servletRedirectorDefined) {
            new ServletRedirector(this.getLogger()).mergeInto(theWebXml);
        }
        if (!jspRedirectorDefined) {
            new JspRedirector(this.getLogger()).mergeInto(theWebXml);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

