/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.api.cactify;

import org.apache.cactus.integration.api.cactify.Redirector;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlTag;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.module.webapp.elements.FilterMapping;
import org.codehaus.cargo.util.log.Logger;

public class FilterRedirector
extends Redirector {
    private static final String FILTER_REDIRECTOR_CLASS = "org.apache.cactus.server.FilterTestRedirector";
    private static final String DEFAULT_FILTER_REDIRECTOR_MAPPING = "/FilterRedirector";

    public FilterRedirector() {
        this.name = "FilterRedirector";
        this.mapping = DEFAULT_FILTER_REDIRECTOR_MAPPING;
    }

    public FilterRedirector(Logger logger) {
        this();
        this.logger = logger;
    }

    public void mergeInto(WebXml theWebXml) {
        if (theWebXml.getVersion() == null) {
            return;
        }
        if (WebXmlVersion.V2_3.compareTo((Object)theWebXml.getVersion()) <= 0) {
            if (WebXmlUtils.getFilterNamesForClass((WebXml)theWebXml, (String)FILTER_REDIRECTOR_CLASS).hasNext() && this.logger != null) {
                this.logger.warn("WARNING: Your web.xml already includes " + this.name + " mapping. Cactus is adding another one " + "which may prevent your container from starting.", "WARNING");
            }
            WebXmlUtils.addFilter((WebXml)theWebXml, (String)this.name, (String)FILTER_REDIRECTOR_CLASS);
            WebXmlTag tag = (WebXmlTag)theWebXml.getDescriptorType().getTagByName("filter-mapping");
            FilterMapping filterMapping = new FilterMapping(tag);
            filterMapping.setName(this.name);
            filterMapping.setUrlPattern(this.mapping);
            filterMapping.setFilterName(this.name);
            WebXmlUtils.addFilterMapping((WebXml)theWebXml, (FilterMapping)filterMapping);
            if (this.roles != null) {
                this.addSecurity(theWebXml);
            }
        }
    }
}

