/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.Functor;
import cats.arrow.FunctionK;
import cats.arrow.FunctionK$;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.syntax.package;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.internal.FreeC;
import fs2.io.file.FileHandle;
import fs2.io.file.ReadCursor$;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ReadCursor<F>
implements Product,
Serializable {
    private final FileHandle file;
    private final long offset;

    public static <F> ReadCursor<F> apply(FileHandle<F> fileHandle, long l) {
        return ReadCursor$.MODULE$.apply(fileHandle, l);
    }

    public static Resource fromPath(Path path, ExecutionContext executionContext, Seq seq, Sync sync, ContextShift contextShift) {
        return ReadCursor$.MODULE$.fromPath(path, executionContext, (Seq<OpenOption>)seq, sync, contextShift);
    }

    public static ReadCursor fromProduct(Product product) {
        return ReadCursor$.MODULE$.fromProduct(product);
    }

    public static <F> ReadCursor<F> unapply(ReadCursor<F> readCursor) {
        return ReadCursor$.MODULE$.unapply(readCursor);
    }

    public static Nil$ fromPath$default$3() {
        return ReadCursor$.MODULE$.fromPath$default$3();
    }

    public <F> ReadCursor(FileHandle<F> file, long offset) {
        this.file = file;
        this.offset = offset;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.file()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ReadCursor)) return false;
        ReadCursor readCursor = (ReadCursor)object;
        if (this.offset() != readCursor.offset()) return false;
        FileHandle<F> fileHandle = this.file();
        FileHandle<F> fileHandle2 = readCursor.file();
        if (fileHandle != null) {
            if (!fileHandle.equals(fileHandle2)) return false;
            return true;
        }
        if (fileHandle2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ReadCursor;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ReadCursor";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = BoxesRunTime.boxToLong((long)this._2());
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "file";
        } else if (1 == n2) {
            string = "offset";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public FileHandle<F> file() {
        return this.file;
    }

    public long offset() {
        return this.offset;
    }

    public F read(int chunkSize, Functor<F> F) {
        return (F)this.read_(chunkSize, FunctionK$.MODULE$.id(), F);
    }

    public FreeC<F, Nothing$, Option<Tuple2<ReadCursor<F>, Chunk<Object>>>> readPull(int chunkSize) {
        Object object = this.read_(chunkSize, (FunctionK)Pull$.MODULE$.functionKInstance(), (Functor)Pull$.MODULE$.monadInstance());
        return object == null ? null : ((Pull)object).fs2$Pull$$free();
    }

    private <G> Object read_(int chunkSize, FunctionK<F, G> u, Functor<G> evidence$1) {
        return package.all$.MODULE$.toFunctorOps(u.apply(this.file().read(chunkSize, this.offset())), evidence$1).map((Function1)(JFunction1 & Serializable)_$3 -> _$3.map((Function1)(JFunction1 & Serializable)chunk -> {
            ReadCursor<F> next = ReadCursor$.MODULE$.apply(this.file(), this.offset() + (long)chunk.size());
            return Tuple2$.MODULE$.apply(next, chunk);
        }));
    }

    public FreeC<F, Object, ReadCursor<F>> readAll(int chunkSize) {
        FreeC<F, Nothing$, Option<Tuple2<ReadCursor<F>, Chunk<Object>>>> freeC = this.readPull(chunkSize);
        return Pull$.MODULE$.flatMap$extension(freeC, (Function1)((JFunction1 & Serializable)arg_0 -> this.readAll$$anonfun$adapted$1(chunkSize, arg_0)));
    }

    public FreeC<F, Object, ReadCursor<F>> readUntil(int chunkSize, long end) {
        FreeC freeC;
        if (this.offset() < end) {
            int toRead = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper((int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(end - this.offset()), Integer.MAX_VALUE)), chunkSize);
            FreeC<F, Nothing$, Option<Tuple2<ReadCursor<F>, Chunk<Object>>>> freeC2 = this.readPull(toRead);
            freeC = Pull$.MODULE$.flatMap$extension(freeC2, (Function1)((JFunction1 & Serializable)arg_0 -> this.readUntil$$anonfun$adapted$1(chunkSize, end, arg_0)));
        } else {
            freeC = Pull$.MODULE$.pure((Object)this);
        }
        return freeC;
    }

    public ReadCursor<F> seek(long position) {
        return ReadCursor$.MODULE$.apply(this.file(), position);
    }

    public FreeC<F, Object, ReadCursor<F>> tail(int chunkSize, FiniteDuration pollDelay, Timer<F> timer) {
        FreeC<F, Nothing$, Option<Tuple2<ReadCursor<F>, Chunk<Object>>>> freeC = this.readPull(chunkSize);
        return Pull$.MODULE$.flatMap$extension(freeC, (Function1)((JFunction1 & Serializable)arg_0 -> this.tail$$anonfun$adapted$1(chunkSize, pollDelay, timer, arg_0)));
    }

    public <F> ReadCursor<F> copy(FileHandle<F> file, long offset) {
        return new ReadCursor<F>(file, offset);
    }

    public <F> FileHandle<F> copy$default$1() {
        return this.file();
    }

    public long copy$default$2() {
        return this.offset();
    }

    public FileHandle<F> _1() {
        return this.file();
    }

    public long _2() {
        return this.offset();
    }

    private static final FreeC readAll$$anonfun$1$$anonfun$1(int chunkSize$1, ReadCursor next$1) {
        return next$1.readAll(chunkSize$1);
    }

    private static final Object readAll$$anonfun$2$$anonfun$adapted$1(int chunkSize$8, ReadCursor next$4) {
        return new Pull(ReadCursor.readAll$$anonfun$1$$anonfun$1(chunkSize$8, next$4));
    }

    private final /* synthetic */ FreeC readAll$$anonfun$3(int chunkSize$2, Option x$1) {
        FreeC freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ReadCursor next = (ReadCursor)tuple2._1();
            Chunk chunk = (Chunk)tuple2._2();
            FreeC freeC2 = Pull$.MODULE$.output(chunk);
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, (Function0)((JFunction0 & Serializable)() -> ReadCursor.readAll$$anonfun$2$$anonfun$adapted$1(chunkSize$2, next)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.pure((Object)this);
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object readAll$$anonfun$adapted$1(int chunkSize$9, Option x$1) {
        return new Pull(this.readAll$$anonfun$3(chunkSize$9, x$1));
    }

    private static final FreeC readUntil$$anonfun$1$$anonfun$1(int chunkSize$3, long end$1, ReadCursor next$2) {
        return next$2.readUntil(chunkSize$3, end$1);
    }

    private static final Object readUntil$$anonfun$2$$anonfun$adapted$1(int chunkSize$10, long end$3, ReadCursor next$5) {
        return new Pull(ReadCursor.readUntil$$anonfun$1$$anonfun$1(chunkSize$10, end$3, next$5));
    }

    private final /* synthetic */ FreeC readUntil$$anonfun$3(int chunkSize$4, long end$2, Option x$1) {
        FreeC freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ReadCursor next = (ReadCursor)tuple2._1();
            Chunk chunk = (Chunk)tuple2._2();
            FreeC freeC2 = Pull$.MODULE$.output(chunk);
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, (Function0)((JFunction0 & Serializable)() -> ReadCursor.readUntil$$anonfun$2$$anonfun$adapted$1(chunkSize$4, end$2, next)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.pure((Object)this);
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object readUntil$$anonfun$adapted$1(int chunkSize$11, long end$4, Option x$1) {
        return new Pull(this.readUntil$$anonfun$3(chunkSize$11, end$4, x$1));
    }

    private static final FreeC tail$$anonfun$1$$anonfun$1(int chunkSize$5, FiniteDuration pollDelay$1, Timer timer$1, ReadCursor next$3) {
        return next$3.tail(chunkSize$5, pollDelay$1, timer$1);
    }

    private static final Object tail$$anonfun$2$$anonfun$adapted$1(int chunkSize$12, FiniteDuration pollDelay$4, Timer timer$4, ReadCursor next$6) {
        return new Pull(ReadCursor.tail$$anonfun$1$$anonfun$1(chunkSize$12, pollDelay$4, timer$4, next$6));
    }

    private final FreeC tail$$anonfun$3$$anonfun$2(int chunkSize$7, FiniteDuration pollDelay$3, Timer timer$3) {
        return this.tail(chunkSize$7, pollDelay$3, timer$3);
    }

    private final Object tail$$anonfun$4$$anonfun$adapted$2(int chunkSize$13, FiniteDuration pollDelay$5, Timer timer$5) {
        return new Pull(this.tail$$anonfun$3$$anonfun$2(chunkSize$13, pollDelay$5, timer$5));
    }

    private final /* synthetic */ FreeC tail$$anonfun$5(int chunkSize$6, FiniteDuration pollDelay$2, Timer timer$2, Option x$1) {
        FreeC freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ReadCursor next = (ReadCursor)tuple2._1();
            Chunk chunk = (Chunk)tuple2._2();
            FreeC freeC2 = Pull$.MODULE$.output(chunk);
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, (Function0)((JFunction0 & Serializable)() -> ReadCursor.tail$$anonfun$2$$anonfun$adapted$1(chunkSize$6, pollDelay$2, timer$2, next)));
        } else if (None$.MODULE$.equals(option)) {
            FreeC freeC3 = Pull$.MODULE$.eval(timer$2.sleep(pollDelay$2));
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC3, (Function0)((JFunction0 & Serializable)() -> this.tail$$anonfun$4$$anonfun$adapted$2(chunkSize$6, pollDelay$2, timer$2)));
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object tail$$anonfun$adapted$1(int chunkSize$14, FiniteDuration pollDelay$6, Timer timer$6, Option x$1) {
        return new Pull(this.tail$$anonfun$5(chunkSize$14, pollDelay$6, timer$6, x$1));
    }
}

