/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.tokenizers;

import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.tokenizers.TokenizationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tokenization {
    private static final Logger log = LoggerFactory.getLogger(Tokenization.class);
    private final SynchronizeHalfDuplexApi<HalfDuplexServiceParam> syncApi;
    private final ApiServiceOption serviceOption;

    public Tokenization() {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).isSSE(false)).streamingMode(StreamingMode.NONE)).outputMode(OutputMode.ACCUMULATE)).taskGroup(null)).task(null)).function("tokenizer")).isService(false)).build();
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Tokenization(String protocol) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.of(protocol))).streamingMode(StreamingMode.NONE)).outputMode(OutputMode.ACCUMULATE)).taskGroup(null)).task(null)).function("tokenizer")).isService(false)).build();
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public TokenizationResult call(HalfDuplexServiceParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        return TokenizationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(HalfDuplexServiceParam param, final ResultCallback<TokenizationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(TokenizationResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public static class Models {
        public static final String QWEN_TURBO = "qwen-turbo";
        public static final String QWEN_PLUS = "qwen-plus";
        public static final String QWEN_7B_CHAT = "qwen-7b-chat";
        public static final String QWEN_14B_CHAT = "qwen-14b-chat";
        public static final String LLAMA2_7B_CHAT_V2 = "llama2-7b-chat-v2";
        public static final String LLAMA2_13B_CHAT_V2 = "llama2-13b-chat-v2";
        public static final String TEXT_EMBEDDING_V1 = "text-embedding-v1";
        public static final String TEXT_EMBEDDING_V2 = "text-embedding-v2";
        public static final String QWEN_72B_CHAT = "qwen-72b-chat";
    }
}

