/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.aigc.multimodalconversation.AudioParameters;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.JsonUtils;
import io.reactivex.Flowable;
import java.util.concurrent.Semaphore;

public class MultiModelConversationQwenTts {
    private static final String MODEL = "qwen-tts-latest";

    public static void call() throws ApiException, NoApiKeyException, UploadFileException {
        MultiModalConversation conv = new MultiModalConversation();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model(MODEL)).text("Today is a wonderful day to build something people love!")).voice(AudioParameters.Voice.DYLAN)).build();
        MultiModalConversationResult result = conv.call((MultiModalConversationParam)param);
        System.out.print(result);
    }

    public static void streamCall() throws ApiException, NoApiKeyException, UploadFileException {
        MultiModalConversation conv = new MultiModalConversation();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model(MODEL)).text("Today is a wonderful day to build something people love!")).voice(AudioParameters.Voice.DYLAN)).build();
        Flowable<MultiModalConversationResult> result = conv.streamCall((MultiModalConversationParam)param);
        result.blockingForEach(System.out::println);
    }

    public static void callWithCallback() throws ApiException, NoApiKeyException, UploadFileException, InputRequiredException {
        MultiModalConversation conv = new MultiModalConversation();
        HalfDuplexServiceParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().model(MODEL)).text("Today is a wonderful day to build something people love!")).voice(AudioParameters.Voice.CHERRY)).build();
        final Semaphore semaphore = new Semaphore(0);
        conv.streamCall((MultiModalConversationParam)param, new ResultCallback<MultiModalConversationResult>(){

            @Override
            public void onEvent(MultiModalConversationResult message) {
                System.out.printf("%s", JsonUtils.toJson(message));
            }

            @Override
            public void onComplete() {
                semaphore.release();
            }

            @Override
            public void onError(Exception e) {
                System.out.printf("error: %s", e.getMessage());
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            MultiModelConversationQwenTts.call();
            MultiModelConversationQwenTts.streamCall();
        }
        catch (ApiException | NoApiKeyException | UploadFileException e) {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }
}

