/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.imagesynthesis;

import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisOutput;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisUsage;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSynthesisResult {
    private static final Logger log = LoggerFactory.getLogger(ImageSynthesisResult.class);
    @SerializedName(value="request_id")
    private String requestId;
    private ImageSynthesisOutput output;
    private ImageSynthesisUsage usage;

    private ImageSynthesisResult() {
    }

    public static ImageSynthesisResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        ImageSynthesisResult result = new ImageSynthesisResult();
        result.requestId = dashScopeResult.getRequestId();
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), ImageSynthesisUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            result.setOutput(JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), ImageSynthesisOutput.class));
        } else {
            log.error(String.format("Result no output: %s", dashScopeResult));
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ImageSynthesisOutput getOutput() {
        return this.output;
    }

    public ImageSynthesisUsage getUsage() {
        return this.usage;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setOutput(ImageSynthesisOutput output) {
        this.output = output;
    }

    public void setUsage(ImageSynthesisUsage usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageSynthesisResult)) {
            return false;
        }
        ImageSynthesisResult other = (ImageSynthesisResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        ImageSynthesisOutput this$output = this.getOutput();
        ImageSynthesisOutput other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        ImageSynthesisUsage this$usage = this.getUsage();
        ImageSynthesisUsage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageSynthesisResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        ImageSynthesisOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        ImageSynthesisUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public String toString() {
        return "ImageSynthesisResult(requestId=" + this.getRequestId() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ")";
    }
}

