/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.phrase;

import com.alibaba.dashscope.audio.asr.phrase.AsrPhraseOperationType;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Map;

public class AsrPhraseParam
extends HalfDuplexServiceParam {
    private static final String TRAIN_TYPE = "compile_asr_phrase";
    private AsrPhraseOperationType operationType;
    private String finetunedOutput;
    private Map<String, Integer> phraseList;
    private Integer pageNo;
    private Integer pageSize;

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.addProperty("model", this.getModel());
        body.addProperty("training_type", TRAIN_TYPE);
        JsonObject hyperParams = new JsonObject();
        if (this.phraseList != null) {
            JsonObject phraseList = new JsonObject();
            for (Map.Entry<String, Integer> entry : this.phraseList.entrySet()) {
                phraseList.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            hyperParams.add("phrase_list", (JsonElement)phraseList);
        }
        body.add("hyper_parameters", (JsonElement)hyperParams);
        if (this.operationType == AsrPhraseOperationType.UPDATE || this.operationType == AsrPhraseOperationType.DELETE || this.operationType == AsrPhraseOperationType.QUERY) {
            body.addProperty("finetuned_output", this.finetunedOutput);
        }
        if (this.operationType == AsrPhraseOperationType.LIST) {
            if (this.pageNo != null) {
                body.addProperty("page_no", (Number)this.pageNo);
            }
            if (this.pageSize != null) {
                body.addProperty("page_size", (Number)this.pageSize);
            }
        }
        return body;
    }

    @Override
    public Object getInput() {
        throw new UnsupportedOperationException("Unimplemented method 'getInput'");
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.operationType == null) {
            throw new InputRequiredException("operationType is required");
        }
        if (!(this.operationType != AsrPhraseOperationType.CREATE && this.operationType != AsrPhraseOperationType.UPDATE || this.phraseList != null && !this.phraseList.isEmpty())) {
            throw new InputRequiredException("phraseList is required when operationType is CREATE or UPDATE");
        }
        if ((this.operationType == AsrPhraseOperationType.UPDATE || this.operationType == AsrPhraseOperationType.DELETE || this.operationType == AsrPhraseOperationType.QUERY) && this.finetunedOutput == null) {
            throw new InputRequiredException("phraseId is required when operationType is UPDATE, DELETE or QUERY");
        }
        if (this.operationType == AsrPhraseOperationType.LIST && this.pageNo != null && this.pageNo < 1) {
            throw new InputRequiredException("pageNo should be greater than or equal to 1");
        }
    }

    protected AsrPhraseParam(AsrPhraseParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.operationType = ((AsrPhraseParamBuilder)b).operationType;
        this.finetunedOutput = ((AsrPhraseParamBuilder)b).finetunedOutput;
        this.phraseList = ((AsrPhraseParamBuilder)b).phraseList;
        this.pageNo = ((AsrPhraseParamBuilder)b).pageNo;
        this.pageSize = ((AsrPhraseParamBuilder)b).pageSize;
    }

    public static AsrPhraseParamBuilder<?, ?> builder() {
        return new AsrPhraseParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsrPhraseParam)) {
            return false;
        }
        AsrPhraseParam other = (AsrPhraseParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$pageNo = this.getPageNo();
        Integer other$pageNo = other.getPageNo();
        if (this$pageNo == null ? other$pageNo != null : !((Object)this$pageNo).equals(other$pageNo)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        AsrPhraseOperationType this$operationType = this.getOperationType();
        AsrPhraseOperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        String this$finetunedOutput = this.getFinetunedOutput();
        String other$finetunedOutput = other.getFinetunedOutput();
        if (this$finetunedOutput == null ? other$finetunedOutput != null : !this$finetunedOutput.equals(other$finetunedOutput)) {
            return false;
        }
        Map<String, Integer> this$phraseList = this.getPhraseList();
        Map<String, Integer> other$phraseList = other.getPhraseList();
        return !(this$phraseList == null ? other$phraseList != null : !((Object)this$phraseList).equals(other$phraseList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AsrPhraseParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $pageNo = this.getPageNo();
        result = result * 59 + ($pageNo == null ? 43 : ((Object)$pageNo).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        AsrPhraseOperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        String $finetunedOutput = this.getFinetunedOutput();
        result = result * 59 + ($finetunedOutput == null ? 43 : $finetunedOutput.hashCode());
        Map<String, Integer> $phraseList = this.getPhraseList();
        result = result * 59 + ($phraseList == null ? 43 : ((Object)$phraseList).hashCode());
        return result;
    }

    public AsrPhraseOperationType getOperationType() {
        return this.operationType;
    }

    public String getFinetunedOutput() {
        return this.finetunedOutput;
    }

    public Map<String, Integer> getPhraseList() {
        return this.phraseList;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setOperationType(AsrPhraseOperationType operationType) {
        this.operationType = operationType;
    }

    public void setFinetunedOutput(String finetunedOutput) {
        this.finetunedOutput = finetunedOutput;
    }

    public void setPhraseList(Map<String, Integer> phraseList) {
        this.phraseList = phraseList;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "AsrPhraseParam(operationType=" + (Object)((Object)this.getOperationType()) + ", finetunedOutput=" + this.getFinetunedOutput() + ", phraseList=" + this.getPhraseList() + ", pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ")";
    }

    private static final class AsrPhraseParamBuilderImpl
    extends AsrPhraseParamBuilder<AsrPhraseParam, AsrPhraseParamBuilderImpl> {
        private AsrPhraseParamBuilderImpl() {
        }

        @Override
        protected AsrPhraseParamBuilderImpl self() {
            return this;
        }

        @Override
        public AsrPhraseParam build() {
            return new AsrPhraseParam(this);
        }
    }

    public static abstract class AsrPhraseParamBuilder<C extends AsrPhraseParam, B extends AsrPhraseParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private AsrPhraseOperationType operationType;
        private String finetunedOutput;
        private Map<String, Integer> phraseList;
        private Integer pageNo;
        private Integer pageSize;

        public B operationType(AsrPhraseOperationType operationType) {
            this.operationType = operationType;
            return (B)this.self();
        }

        public B finetunedOutput(String finetunedOutput) {
            this.finetunedOutput = finetunedOutput;
            return (B)this.self();
        }

        public B phraseList(Map<String, Integer> phraseList) {
            this.phraseList = phraseList;
            return (B)this.self();
        }

        public B pageNo(Integer pageNo) {
            this.pageNo = pageNo;
            return (B)this.self();
        }

        public B pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AsrPhraseParam.AsrPhraseParamBuilder(super=" + super.toString() + ", operationType=" + (Object)((Object)this.operationType) + ", finetunedOutput=" + this.finetunedOutput + ", phraseList=" + this.phraseList + ", pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ")";
        }
    }
}

