/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.translation.results;

import com.alibaba.dashscope.audio.asr.translation.results.Translation;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslationResult {
    private Map<String, Translation> translations = new HashMap<String, Translation>();
    private boolean sentenceEnd = false;

    public Translation getTranslation(String language) {
        return this.translations.get(language);
    }

    public List<String> getLanguageList() {
        return new ArrayList<String>(this.translations.keySet());
    }

    public boolean isSentenceEnd() {
        return this.sentenceEnd;
    }

    public static TranslationResult from(JsonArray json_array) {
        if (json_array != null) {
            TranslationResult result = new TranslationResult();
            for (int i = 0; i < json_array.size(); ++i) {
                JsonObject json = json_array.get(i).getAsJsonObject();
                Translation translation = Translation.from(json);
                result.translations.put(translation.getLanguage(), translation);
                if (!translation.sentenceEnd) continue;
                result.sentenceEnd = true;
            }
            return result;
        }
        return null;
    }

    public Map<String, Translation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Map<String, Translation> translations) {
        this.translations = translations;
    }

    public void setSentenceEnd(boolean sentenceEnd) {
        this.sentenceEnd = sentenceEnd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationResult)) {
            return false;
        }
        TranslationResult other = (TranslationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSentenceEnd() != other.isSentenceEnd()) {
            return false;
        }
        Map<String, Translation> this$translations = this.getTranslations();
        Map<String, Translation> other$translations = other.getTranslations();
        return !(this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSentenceEnd() ? 79 : 97);
        Map<String, Translation> $translations = this.getTranslations();
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        return result;
    }

    public String toString() {
        return "TranslationResult(translations=" + this.getTranslations() + ", sentenceEnd=" + this.isSentenceEnd() + ")";
    }
}

