/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class EncryptionKey {
    @SerializedName(value="request_id")
    private String requestId;
    @SerializedName(value="public_key")
    private String publicKey;
    @SerializedName(value="public_key_id")
    private String publicKeyId;

    private EncryptionKey() {
    }

    public static EncryptionKey fromDashScopeResult(DashScopeResult result) {
        JsonObject dashscopeResult = (JsonObject)result.getOutput();
        EncryptionKey encryptionKey = JsonUtils.fromJsonObject(dashscopeResult.get("data"), EncryptionKey.class);
        encryptionKey.setRequestId(dashscopeResult.get("request_id").getAsString());
        encryptionKey.setPublicKey(encryptionKey.getPublicKey());
        return encryptionKey;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKeyId(String publicKeyId) {
        this.publicKeyId = publicKeyId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey other = (EncryptionKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$publicKeyId = this.getPublicKeyId();
        String other$publicKeyId = other.getPublicKeyId();
        return !(this$publicKeyId == null ? other$publicKeyId != null : !this$publicKeyId.equals(other$publicKeyId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptionKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $publicKeyId = this.getPublicKeyId();
        result = result * 59 + ($publicKeyId == null ? 43 : $publicKeyId.hashCode());
        return result;
    }

    public String toString() {
        return "EncryptionKey(requestId=" + this.getRequestId() + ", publicKey=" + this.getPublicKey() + ", publicKeyId=" + this.getPublicKeyId() + ")";
    }
}

