/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateAccountRequest
extends Request {
    @Query
    @NameInMap(value="AccountDescription")
    private String accountDescription;
    @Query
    @NameInMap(value="AccountName")
    @Validation(required=true)
    private String accountName;
    @Query
    @NameInMap(value="AccountPassword")
    @Validation(required=true)
    private String accountPassword;
    @Query
    @NameInMap(value="AccountType")
    @Validation(required=true)
    private String accountType;
    @Query
    @NameInMap(value="DBClusterId")
    @Validation(required=true)
    private String DBClusterId;
    @Query
    @NameInMap(value="Engine")
    private String engine;

    private CreateAccountRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accountDescription = builder.accountDescription;
        this.accountName = builder.accountName;
        this.accountPassword = builder.accountPassword;
        this.accountType = builder.accountType;
        this.DBClusterId = builder.DBClusterId;
        this.engine = builder.engine;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateAccountRequest create() {
        return CreateAccountRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccountDescription() {
        return this.accountDescription;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountPassword() {
        return this.accountPassword;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getDBClusterId() {
        return this.DBClusterId;
    }

    public String getEngine() {
        return this.engine;
    }

    public static final class Builder
    extends Request.Builder<CreateAccountRequest, Builder> {
        private String accountDescription;
        private String accountName;
        private String accountPassword;
        private String accountType;
        private String DBClusterId;
        private String engine;

        private Builder() {
        }

        private Builder(CreateAccountRequest request) {
            super((Request)request);
            this.accountDescription = request.accountDescription;
            this.accountName = request.accountName;
            this.accountPassword = request.accountPassword;
            this.accountType = request.accountType;
            this.DBClusterId = request.DBClusterId;
            this.engine = request.engine;
        }

        public Builder accountDescription(String accountDescription) {
            this.putQueryParameter("AccountDescription", accountDescription);
            this.accountDescription = accountDescription;
            return this;
        }

        public Builder accountName(String accountName) {
            this.putQueryParameter("AccountName", accountName);
            this.accountName = accountName;
            return this;
        }

        public Builder accountPassword(String accountPassword) {
            this.putQueryParameter("AccountPassword", accountPassword);
            this.accountPassword = accountPassword;
            return this;
        }

        public Builder accountType(String accountType) {
            this.putQueryParameter("AccountType", accountType);
            this.accountType = accountType;
            return this;
        }

        public Builder DBClusterId(String DBClusterId) {
            this.putQueryParameter("DBClusterId", DBClusterId);
            this.DBClusterId = DBClusterId;
            return this;
        }

        public Builder engine(String engine) {
            this.putQueryParameter("Engine", engine);
            this.engine = engine;
            return this;
        }

        public CreateAccountRequest build() {
            return new CreateAccountRequest(this);
        }
    }
}

