/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateLakeStorageRequest
extends Request {
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Body
    @NameInMap(value="DBClusterId")
    private String DBClusterId;
    @Body
    @NameInMap(value="Description")
    private String description;
    @Body
    @NameInMap(value="Permissions")
    private List<Permissions> permissions;
    @Body
    @NameInMap(value="RegionId")
    private String regionId;

    private CreateLakeStorageRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clientToken = builder.clientToken;
        this.DBClusterId = builder.DBClusterId;
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateLakeStorageRequest create() {
        return CreateLakeStorageRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getDBClusterId() {
        return this.DBClusterId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Permissions> getPermissions() {
        return this.permissions;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static class Permissions
    extends TeaModel {
        @NameInMap(value="Account")
        private String account;
        @NameInMap(value="Read")
        private Boolean read;
        @NameInMap(value="Type")
        private String type;
        @NameInMap(value="Write")
        private Boolean write;

        private Permissions(Builder builder) {
            this.account = builder.account;
            this.read = builder.read;
            this.type = builder.type;
            this.write = builder.write;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Permissions create() {
            return Permissions.builder().build();
        }

        public String getAccount() {
            return this.account;
        }

        public Boolean getRead() {
            return this.read;
        }

        public String getType() {
            return this.type;
        }

        public Boolean getWrite() {
            return this.write;
        }

        public static final class Builder {
            private String account;
            private Boolean read;
            private String type;
            private Boolean write;

            private Builder() {
            }

            private Builder(Permissions model) {
                this.account = model.account;
                this.read = model.read;
                this.type = model.type;
                this.write = model.write;
            }

            public Builder account(String account) {
                this.account = account;
                return this;
            }

            public Builder read(Boolean read) {
                this.read = read;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder write(Boolean write) {
                this.write = write;
                return this;
            }

            public Permissions build() {
                return new Permissions(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateLakeStorageRequest, Builder> {
        private String clientToken;
        private String DBClusterId;
        private String description;
        private List<Permissions> permissions;
        private String regionId;

        private Builder() {
        }

        private Builder(CreateLakeStorageRequest request) {
            super((Request)request);
            this.clientToken = request.clientToken;
            this.DBClusterId = request.DBClusterId;
            this.description = request.description;
            this.permissions = request.permissions;
            this.regionId = request.regionId;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder DBClusterId(String DBClusterId) {
            this.putBodyParameter("DBClusterId", DBClusterId);
            this.DBClusterId = DBClusterId;
            return this;
        }

        public Builder description(String description) {
            this.putBodyParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder permissions(List<Permissions> permissions) {
            String permissionsShrink = this.shrink(permissions, "Permissions", "json");
            this.putBodyParameter("Permissions", permissionsShrink);
            this.permissions = permissions;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putBodyParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public CreateLakeStorageRequest build() {
            return new CreateLakeStorageRequest(this);
        }
    }
}

