/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeAPSADBInstancesRequest
extends Request {
    @Query
    @NameInMap(value="PageNumber")
    @Validation(required=true, maximum=10000.0, minimum=1.0)
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=1000.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;

    private DescribeAPSADBInstancesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeAPSADBInstancesRequest create() {
        return DescribeAPSADBInstancesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static final class Builder
    extends Request.Builder<DescribeAPSADBInstancesRequest, Builder> {
        private Integer pageNumber;
        private Integer pageSize;
        private String regionId;

        private Builder() {
        }

        private Builder(DescribeAPSADBInstancesRequest request) {
            super((Request)request);
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public DescribeAPSADBInstancesRequest build() {
            return new DescribeAPSADBInstancesRequest(this);
        }
    }
}

