/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListSparkAppAttemptsRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="DBClusterId")
    private String DBClusterId;
    @Query
    @NameInMap(value="PageNumber")
    @Validation(required=true, minimum=1.0)
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Long pageSize;

    private ListSparkAppAttemptsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.DBClusterId = builder.DBClusterId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListSparkAppAttemptsRequest create() {
        return ListSparkAppAttemptsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDBClusterId() {
        return this.DBClusterId;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<ListSparkAppAttemptsRequest, Builder> {
        private String appId;
        private String DBClusterId;
        private Long pageNumber;
        private Long pageSize;

        private Builder() {
        }

        private Builder(ListSparkAppAttemptsRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.DBClusterId = request.DBClusterId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder DBClusterId(String DBClusterId) {
            this.putQueryParameter("DBClusterId", DBClusterId);
            this.DBClusterId = DBClusterId;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListSparkAppAttemptsRequest build() {
            return new ListSparkAppAttemptsRequest(this);
        }
    }
}

