/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ModifyAccountPrivilegesRequest
extends Request {
    @Query
    @NameInMap(value="AccountName")
    @Validation(required=true)
    private String accountName;
    @Query
    @NameInMap(value="AccountPrivileges")
    @Validation(required=true)
    private List<AccountPrivileges> accountPrivileges;
    @Query
    @NameInMap(value="DBClusterId")
    @Validation(required=true)
    private String DBClusterId;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;

    private ModifyAccountPrivilegesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accountName = builder.accountName;
        this.accountPrivileges = builder.accountPrivileges;
        this.DBClusterId = builder.DBClusterId;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyAccountPrivilegesRequest create() {
        return ModifyAccountPrivilegesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public List<AccountPrivileges> getAccountPrivileges() {
        return this.accountPrivileges;
    }

    public String getDBClusterId() {
        return this.DBClusterId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static class AccountPrivileges
    extends TeaModel {
        @NameInMap(value="PrivilegeObject")
        private PrivilegeObject privilegeObject;
        @NameInMap(value="PrivilegeType")
        private String privilegeType;
        @NameInMap(value="Privileges")
        private List<String> privileges;

        private AccountPrivileges(Builder builder) {
            this.privilegeObject = builder.privilegeObject;
            this.privilegeType = builder.privilegeType;
            this.privileges = builder.privileges;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AccountPrivileges create() {
            return AccountPrivileges.builder().build();
        }

        public PrivilegeObject getPrivilegeObject() {
            return this.privilegeObject;
        }

        public String getPrivilegeType() {
            return this.privilegeType;
        }

        public List<String> getPrivileges() {
            return this.privileges;
        }

        public static final class Builder {
            private PrivilegeObject privilegeObject;
            private String privilegeType;
            private List<String> privileges;

            private Builder() {
            }

            private Builder(AccountPrivileges model) {
                this.privilegeObject = model.privilegeObject;
                this.privilegeType = model.privilegeType;
                this.privileges = model.privileges;
            }

            public Builder privilegeObject(PrivilegeObject privilegeObject) {
                this.privilegeObject = privilegeObject;
                return this;
            }

            public Builder privilegeType(String privilegeType) {
                this.privilegeType = privilegeType;
                return this;
            }

            public Builder privileges(List<String> privileges) {
                this.privileges = privileges;
                return this;
            }

            public AccountPrivileges build() {
                return new AccountPrivileges(this);
            }
        }
    }

    public static class PrivilegeObject
    extends TeaModel {
        @NameInMap(value="Column")
        private String column;
        @NameInMap(value="Database")
        private String database;
        @NameInMap(value="Table")
        private String table;

        private PrivilegeObject(Builder builder) {
            this.column = builder.column;
            this.database = builder.database;
            this.table = builder.table;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static PrivilegeObject create() {
            return PrivilegeObject.builder().build();
        }

        public String getColumn() {
            return this.column;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTable() {
            return this.table;
        }

        public static final class Builder {
            private String column;
            private String database;
            private String table;

            private Builder() {
            }

            private Builder(PrivilegeObject model) {
                this.column = model.column;
                this.database = model.database;
                this.table = model.table;
            }

            public Builder column(String column) {
                this.column = column;
                return this;
            }

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder table(String table) {
                this.table = table;
                return this;
            }

            public PrivilegeObject build() {
                return new PrivilegeObject(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ModifyAccountPrivilegesRequest, Builder> {
        private String accountName;
        private List<AccountPrivileges> accountPrivileges;
        private String DBClusterId;
        private String regionId;

        private Builder() {
        }

        private Builder(ModifyAccountPrivilegesRequest request) {
            super((Request)request);
            this.accountName = request.accountName;
            this.accountPrivileges = request.accountPrivileges;
            this.DBClusterId = request.DBClusterId;
            this.regionId = request.regionId;
        }

        public Builder accountName(String accountName) {
            this.putQueryParameter("AccountName", accountName);
            this.accountName = accountName;
            return this;
        }

        public Builder accountPrivileges(List<AccountPrivileges> accountPrivileges) {
            String accountPrivilegesShrink = this.shrink(accountPrivileges, "AccountPrivileges", "json");
            this.putQueryParameter("AccountPrivileges", accountPrivilegesShrink);
            this.accountPrivileges = accountPrivileges;
            return this;
        }

        public Builder DBClusterId(String DBClusterId) {
            this.putQueryParameter("DBClusterId", DBClusterId);
            this.DBClusterId = DBClusterId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public ModifyAccountPrivilegesRequest build() {
            return new ModifyAccountPrivilegesRequest(this);
        }
    }
}

