/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ModifyDBClusterSSLRequest
extends Request {
    @Query
    @NameInMap(value="ConnectionString")
    private String connectionString;
    @Query
    @NameInMap(value="DBClusterId")
    @Validation(required=true)
    private String DBClusterId;
    @Query
    @NameInMap(value="EnableSSL")
    @Validation(required=true)
    private Boolean enableSSL;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;

    private ModifyDBClusterSSLRequest(Builder builder) {
        super((Request.Builder)builder);
        this.connectionString = builder.connectionString;
        this.DBClusterId = builder.DBClusterId;
        this.enableSSL = builder.enableSSL;
        this.regionId = builder.regionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyDBClusterSSLRequest create() {
        return ModifyDBClusterSSLRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getDBClusterId() {
        return this.DBClusterId;
    }

    public Boolean getEnableSSL() {
        return this.enableSSL;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public static final class Builder
    extends Request.Builder<ModifyDBClusterSSLRequest, Builder> {
        private String connectionString;
        private String DBClusterId;
        private Boolean enableSSL;
        private String regionId;

        private Builder() {
        }

        private Builder(ModifyDBClusterSSLRequest request) {
            super((Request)request);
            this.connectionString = request.connectionString;
            this.DBClusterId = request.DBClusterId;
            this.enableSSL = request.enableSSL;
            this.regionId = request.regionId;
        }

        public Builder connectionString(String connectionString) {
            this.putQueryParameter("ConnectionString", connectionString);
            this.connectionString = connectionString;
            return this;
        }

        public Builder DBClusterId(String DBClusterId) {
            this.putQueryParameter("DBClusterId", DBClusterId);
            this.DBClusterId = DBClusterId;
            return this;
        }

        public Builder enableSSL(Boolean enableSSL) {
            this.putQueryParameter("EnableSSL", enableSSL);
            this.enableSSL = enableSSL;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public ModifyDBClusterSSLRequest build() {
            return new ModifyDBClusterSSLRequest(this);
        }
    }
}

