/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;
import java.util.Map;

public class ModifyDBResourceGroupRequest
extends Request {
    @Query
    @NameInMap(value="AutoStopInterval")
    private String autoStopInterval;
    @Query
    @NameInMap(value="ClusterMode")
    private String clusterMode;
    @Query
    @NameInMap(value="ClusterSizeResource")
    private String clusterSizeResource;
    @Query
    @NameInMap(value="DBClusterId")
    @Validation(required=true)
    private String DBClusterId;
    @Query
    @NameInMap(value="EnableSpot")
    private Boolean enableSpot;
    @Query
    @NameInMap(value="EngineParams")
    private Map<String, ?> engineParams;
    @Query
    @NameInMap(value="GroupName")
    @Validation(required=true)
    private String groupName;
    @Query
    @NameInMap(value="GroupType")
    @Validation(required=true)
    private String groupType;
    @Query
    @NameInMap(value="MaxClusterCount")
    private Integer maxClusterCount;
    @Query
    @NameInMap(value="MaxComputeResource")
    private String maxComputeResource;
    @Query
    @NameInMap(value="MaxGpuQuantity")
    private Integer maxGpuQuantity;
    @Query
    @NameInMap(value="MinClusterCount")
    private Integer minClusterCount;
    @Query
    @NameInMap(value="MinComputeResource")
    private String minComputeResource;
    @Query
    @NameInMap(value="MinGpuQuantity")
    private Integer minGpuQuantity;
    @Query
    @NameInMap(value="RayConfig")
    private RayConfig rayConfig;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="Rules")
    private List<Rules> rules;
    @Query
    @NameInMap(value="SpecName")
    private String specName;
    @Query
    @NameInMap(value="Status")
    private String status;
    @Query
    @NameInMap(value="TargetResourceGroupName")
    private String targetResourceGroupName;

    private ModifyDBResourceGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.autoStopInterval = builder.autoStopInterval;
        this.clusterMode = builder.clusterMode;
        this.clusterSizeResource = builder.clusterSizeResource;
        this.DBClusterId = builder.DBClusterId;
        this.enableSpot = builder.enableSpot;
        this.engineParams = builder.engineParams;
        this.groupName = builder.groupName;
        this.groupType = builder.groupType;
        this.maxClusterCount = builder.maxClusterCount;
        this.maxComputeResource = builder.maxComputeResource;
        this.maxGpuQuantity = builder.maxGpuQuantity;
        this.minClusterCount = builder.minClusterCount;
        this.minComputeResource = builder.minComputeResource;
        this.minGpuQuantity = builder.minGpuQuantity;
        this.rayConfig = builder.rayConfig;
        this.regionId = builder.regionId;
        this.rules = builder.rules;
        this.specName = builder.specName;
        this.status = builder.status;
        this.targetResourceGroupName = builder.targetResourceGroupName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyDBResourceGroupRequest create() {
        return ModifyDBResourceGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAutoStopInterval() {
        return this.autoStopInterval;
    }

    public String getClusterMode() {
        return this.clusterMode;
    }

    public String getClusterSizeResource() {
        return this.clusterSizeResource;
    }

    public String getDBClusterId() {
        return this.DBClusterId;
    }

    public Boolean getEnableSpot() {
        return this.enableSpot;
    }

    public Map<String, ?> getEngineParams() {
        return this.engineParams;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public Integer getMaxClusterCount() {
        return this.maxClusterCount;
    }

    public String getMaxComputeResource() {
        return this.maxComputeResource;
    }

    public Integer getMaxGpuQuantity() {
        return this.maxGpuQuantity;
    }

    public Integer getMinClusterCount() {
        return this.minClusterCount;
    }

    public String getMinComputeResource() {
        return this.minComputeResource;
    }

    public Integer getMinGpuQuantity() {
        return this.minGpuQuantity;
    }

    public RayConfig getRayConfig() {
        return this.rayConfig;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public List<Rules> getRules() {
        return this.rules;
    }

    public String getSpecName() {
        return this.specName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTargetResourceGroupName() {
        return this.targetResourceGroupName;
    }

    public static class Rules
    extends TeaModel {
        @NameInMap(value="GroupName")
        private String groupName;
        @NameInMap(value="QueryTime")
        private String queryTime;
        @NameInMap(value="TargetGroupName")
        private String targetGroupName;

        private Rules(Builder builder) {
            this.groupName = builder.groupName;
            this.queryTime = builder.queryTime;
            this.targetGroupName = builder.targetGroupName;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Rules create() {
            return Rules.builder().build();
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getQueryTime() {
            return this.queryTime;
        }

        public String getTargetGroupName() {
            return this.targetGroupName;
        }

        public static final class Builder {
            private String groupName;
            private String queryTime;
            private String targetGroupName;

            private Builder() {
            }

            private Builder(Rules model) {
                this.groupName = model.groupName;
                this.queryTime = model.queryTime;
                this.targetGroupName = model.targetGroupName;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder queryTime(String queryTime) {
                this.queryTime = queryTime;
                return this;
            }

            public Builder targetGroupName(String targetGroupName) {
                this.targetGroupName = targetGroupName;
                return this;
            }

            public Rules build() {
                return new Rules(this);
            }
        }
    }

    public static class RayConfig
    extends TeaModel {
        @NameInMap(value="AppConfig")
        private AppConfig appConfig;
        @NameInMap(value="Category")
        private String category;
        @NameInMap(value="EnableUserEni")
        private Boolean enableUserEni;
        @NameInMap(value="HeadAllocateUnit")
        private String headAllocateUnit;
        @NameInMap(value="HeadDiskCapacity")
        private String headDiskCapacity;
        @NameInMap(value="HeadSpec")
        private String headSpec;
        @NameInMap(value="HeadSpecType")
        private String headSpecType;
        @NameInMap(value="StorageMounts")
        private List<StorageMounts> storageMounts;
        @NameInMap(value="WorkerGroups")
        private List<WorkerGroups> workerGroups;

        private RayConfig(Builder builder) {
            this.appConfig = builder.appConfig;
            this.category = builder.category;
            this.enableUserEni = builder.enableUserEni;
            this.headAllocateUnit = builder.headAllocateUnit;
            this.headDiskCapacity = builder.headDiskCapacity;
            this.headSpec = builder.headSpec;
            this.headSpecType = builder.headSpecType;
            this.storageMounts = builder.storageMounts;
            this.workerGroups = builder.workerGroups;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static RayConfig create() {
            return RayConfig.builder().build();
        }

        public AppConfig getAppConfig() {
            return this.appConfig;
        }

        public String getCategory() {
            return this.category;
        }

        public Boolean getEnableUserEni() {
            return this.enableUserEni;
        }

        public String getHeadAllocateUnit() {
            return this.headAllocateUnit;
        }

        public String getHeadDiskCapacity() {
            return this.headDiskCapacity;
        }

        public String getHeadSpec() {
            return this.headSpec;
        }

        public String getHeadSpecType() {
            return this.headSpecType;
        }

        public List<StorageMounts> getStorageMounts() {
            return this.storageMounts;
        }

        public List<WorkerGroups> getWorkerGroups() {
            return this.workerGroups;
        }

        public static final class Builder {
            private AppConfig appConfig;
            private String category;
            private Boolean enableUserEni;
            private String headAllocateUnit;
            private String headDiskCapacity;
            private String headSpec;
            private String headSpecType;
            private List<StorageMounts> storageMounts;
            private List<WorkerGroups> workerGroups;

            private Builder() {
            }

            private Builder(RayConfig model) {
                this.appConfig = model.appConfig;
                this.category = model.category;
                this.enableUserEni = model.enableUserEni;
                this.headAllocateUnit = model.headAllocateUnit;
                this.headDiskCapacity = model.headDiskCapacity;
                this.headSpec = model.headSpec;
                this.headSpecType = model.headSpecType;
                this.storageMounts = model.storageMounts;
                this.workerGroups = model.workerGroups;
            }

            public Builder appConfig(AppConfig appConfig) {
                this.appConfig = appConfig;
                return this;
            }

            public Builder category(String category) {
                this.category = category;
                return this;
            }

            public Builder enableUserEni(Boolean enableUserEni) {
                this.enableUserEni = enableUserEni;
                return this;
            }

            public Builder headAllocateUnit(String headAllocateUnit) {
                this.headAllocateUnit = headAllocateUnit;
                return this;
            }

            public Builder headDiskCapacity(String headDiskCapacity) {
                this.headDiskCapacity = headDiskCapacity;
                return this;
            }

            public Builder headSpec(String headSpec) {
                this.headSpec = headSpec;
                return this;
            }

            public Builder headSpecType(String headSpecType) {
                this.headSpecType = headSpecType;
                return this;
            }

            public Builder storageMounts(List<StorageMounts> storageMounts) {
                this.storageMounts = storageMounts;
                return this;
            }

            public Builder workerGroups(List<WorkerGroups> workerGroups) {
                this.workerGroups = workerGroups;
                return this;
            }

            public RayConfig build() {
                return new RayConfig(this);
            }
        }
    }

    public static class WorkerGroups
    extends TeaModel {
        @NameInMap(value="AllocateUnit")
        private String allocateUnit;
        @NameInMap(value="GroupName")
        private String groupName;
        @NameInMap(value="MaxWorkerQuantity")
        private Integer maxWorkerQuantity;
        @NameInMap(value="MinWorkerQuantity")
        private Integer minWorkerQuantity;
        @NameInMap(value="WorkerDiskCapacity")
        private String workerDiskCapacity;
        @NameInMap(value="WorkerSpecName")
        private String workerSpecName;
        @NameInMap(value="WorkerSpecType")
        private String workerSpecType;

        private WorkerGroups(Builder builder) {
            this.allocateUnit = builder.allocateUnit;
            this.groupName = builder.groupName;
            this.maxWorkerQuantity = builder.maxWorkerQuantity;
            this.minWorkerQuantity = builder.minWorkerQuantity;
            this.workerDiskCapacity = builder.workerDiskCapacity;
            this.workerSpecName = builder.workerSpecName;
            this.workerSpecType = builder.workerSpecType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static WorkerGroups create() {
            return WorkerGroups.builder().build();
        }

        public String getAllocateUnit() {
            return this.allocateUnit;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public Integer getMaxWorkerQuantity() {
            return this.maxWorkerQuantity;
        }

        public Integer getMinWorkerQuantity() {
            return this.minWorkerQuantity;
        }

        public String getWorkerDiskCapacity() {
            return this.workerDiskCapacity;
        }

        public String getWorkerSpecName() {
            return this.workerSpecName;
        }

        public String getWorkerSpecType() {
            return this.workerSpecType;
        }

        public static final class Builder {
            private String allocateUnit;
            private String groupName;
            private Integer maxWorkerQuantity;
            private Integer minWorkerQuantity;
            private String workerDiskCapacity;
            private String workerSpecName;
            private String workerSpecType;

            private Builder() {
            }

            private Builder(WorkerGroups model) {
                this.allocateUnit = model.allocateUnit;
                this.groupName = model.groupName;
                this.maxWorkerQuantity = model.maxWorkerQuantity;
                this.minWorkerQuantity = model.minWorkerQuantity;
                this.workerDiskCapacity = model.workerDiskCapacity;
                this.workerSpecName = model.workerSpecName;
                this.workerSpecType = model.workerSpecType;
            }

            public Builder allocateUnit(String allocateUnit) {
                this.allocateUnit = allocateUnit;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder maxWorkerQuantity(Integer maxWorkerQuantity) {
                this.maxWorkerQuantity = maxWorkerQuantity;
                return this;
            }

            public Builder minWorkerQuantity(Integer minWorkerQuantity) {
                this.minWorkerQuantity = minWorkerQuantity;
                return this;
            }

            public Builder workerDiskCapacity(String workerDiskCapacity) {
                this.workerDiskCapacity = workerDiskCapacity;
                return this;
            }

            public Builder workerSpecName(String workerSpecName) {
                this.workerSpecName = workerSpecName;
                return this;
            }

            public Builder workerSpecType(String workerSpecType) {
                this.workerSpecType = workerSpecType;
                return this;
            }

            public WorkerGroups build() {
                return new WorkerGroups(this);
            }
        }
    }

    public static class StorageMounts
    extends TeaModel {
        @NameInMap(value="MountPath")
        private String mountPath;
        @NameInMap(value="StorageId")
        private Long storageId;

        private StorageMounts(Builder builder) {
            this.mountPath = builder.mountPath;
            this.storageId = builder.storageId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static StorageMounts create() {
            return StorageMounts.builder().build();
        }

        public String getMountPath() {
            return this.mountPath;
        }

        public Long getStorageId() {
            return this.storageId;
        }

        public static final class Builder {
            private String mountPath;
            private Long storageId;

            private Builder() {
            }

            private Builder(StorageMounts model) {
                this.mountPath = model.mountPath;
                this.storageId = model.storageId;
            }

            public Builder mountPath(String mountPath) {
                this.mountPath = mountPath;
                return this;
            }

            public Builder storageId(Long storageId) {
                this.storageId = storageId;
                return this;
            }

            public StorageMounts build() {
                return new StorageMounts(this);
            }
        }
    }

    public static class AppConfig
    extends TeaModel {
        @NameInMap(value="AppName")
        private String appName;
        @NameInMap(value="AppType")
        private String appType;
        @NameInMap(value="ImageSelector")
        private ImageSelector imageSelector;

        private AppConfig(Builder builder) {
            this.appName = builder.appName;
            this.appType = builder.appType;
            this.imageSelector = builder.imageSelector;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AppConfig create() {
            return AppConfig.builder().build();
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppType() {
            return this.appType;
        }

        public ImageSelector getImageSelector() {
            return this.imageSelector;
        }

        public static final class Builder {
            private String appName;
            private String appType;
            private ImageSelector imageSelector;

            private Builder() {
            }

            private Builder(AppConfig model) {
                this.appName = model.appName;
                this.appType = model.appType;
                this.imageSelector = model.imageSelector;
            }

            public Builder appName(String appName) {
                this.appName = appName;
                return this;
            }

            public Builder appType(String appType) {
                this.appType = appType;
                return this;
            }

            public Builder imageSelector(ImageSelector imageSelector) {
                this.imageSelector = imageSelector;
                return this;
            }

            public AppConfig build() {
                return new AppConfig(this);
            }
        }
    }

    public static class ImageSelector
    extends TeaModel {
        @NameInMap(value="Image")
        private String image;
        @NameInMap(value="InferenceEngine")
        private String inferenceEngine;
        @NameInMap(value="LlmModel")
        private String llmModel;

        private ImageSelector(Builder builder) {
            this.image = builder.image;
            this.inferenceEngine = builder.inferenceEngine;
            this.llmModel = builder.llmModel;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ImageSelector create() {
            return ImageSelector.builder().build();
        }

        public String getImage() {
            return this.image;
        }

        public String getInferenceEngine() {
            return this.inferenceEngine;
        }

        public String getLlmModel() {
            return this.llmModel;
        }

        public static final class Builder {
            private String image;
            private String inferenceEngine;
            private String llmModel;

            private Builder() {
            }

            private Builder(ImageSelector model) {
                this.image = model.image;
                this.inferenceEngine = model.inferenceEngine;
                this.llmModel = model.llmModel;
            }

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder inferenceEngine(String inferenceEngine) {
                this.inferenceEngine = inferenceEngine;
                return this;
            }

            public Builder llmModel(String llmModel) {
                this.llmModel = llmModel;
                return this;
            }

            public ImageSelector build() {
                return new ImageSelector(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ModifyDBResourceGroupRequest, Builder> {
        private String autoStopInterval;
        private String clusterMode;
        private String clusterSizeResource;
        private String DBClusterId;
        private Boolean enableSpot;
        private Map<String, ?> engineParams;
        private String groupName;
        private String groupType;
        private Integer maxClusterCount;
        private String maxComputeResource;
        private Integer maxGpuQuantity;
        private Integer minClusterCount;
        private String minComputeResource;
        private Integer minGpuQuantity;
        private RayConfig rayConfig;
        private String regionId;
        private List<Rules> rules;
        private String specName;
        private String status;
        private String targetResourceGroupName;

        private Builder() {
        }

        private Builder(ModifyDBResourceGroupRequest request) {
            super((Request)request);
            this.autoStopInterval = request.autoStopInterval;
            this.clusterMode = request.clusterMode;
            this.clusterSizeResource = request.clusterSizeResource;
            this.DBClusterId = request.DBClusterId;
            this.enableSpot = request.enableSpot;
            this.engineParams = request.engineParams;
            this.groupName = request.groupName;
            this.groupType = request.groupType;
            this.maxClusterCount = request.maxClusterCount;
            this.maxComputeResource = request.maxComputeResource;
            this.maxGpuQuantity = request.maxGpuQuantity;
            this.minClusterCount = request.minClusterCount;
            this.minComputeResource = request.minComputeResource;
            this.minGpuQuantity = request.minGpuQuantity;
            this.rayConfig = request.rayConfig;
            this.regionId = request.regionId;
            this.rules = request.rules;
            this.specName = request.specName;
            this.status = request.status;
            this.targetResourceGroupName = request.targetResourceGroupName;
        }

        public Builder autoStopInterval(String autoStopInterval) {
            this.putQueryParameter("AutoStopInterval", autoStopInterval);
            this.autoStopInterval = autoStopInterval;
            return this;
        }

        public Builder clusterMode(String clusterMode) {
            this.putQueryParameter("ClusterMode", clusterMode);
            this.clusterMode = clusterMode;
            return this;
        }

        public Builder clusterSizeResource(String clusterSizeResource) {
            this.putQueryParameter("ClusterSizeResource", clusterSizeResource);
            this.clusterSizeResource = clusterSizeResource;
            return this;
        }

        public Builder DBClusterId(String DBClusterId) {
            this.putQueryParameter("DBClusterId", DBClusterId);
            this.DBClusterId = DBClusterId;
            return this;
        }

        public Builder enableSpot(Boolean enableSpot) {
            this.putQueryParameter("EnableSpot", enableSpot);
            this.enableSpot = enableSpot;
            return this;
        }

        public Builder engineParams(Map<String, ?> engineParams) {
            String engineParamsShrink = this.shrink(engineParams, "EngineParams", "json");
            this.putQueryParameter("EngineParams", engineParamsShrink);
            this.engineParams = engineParams;
            return this;
        }

        public Builder groupName(String groupName) {
            this.putQueryParameter("GroupName", groupName);
            this.groupName = groupName;
            return this;
        }

        public Builder groupType(String groupType) {
            this.putQueryParameter("GroupType", groupType);
            this.groupType = groupType;
            return this;
        }

        public Builder maxClusterCount(Integer maxClusterCount) {
            this.putQueryParameter("MaxClusterCount", maxClusterCount);
            this.maxClusterCount = maxClusterCount;
            return this;
        }

        public Builder maxComputeResource(String maxComputeResource) {
            this.putQueryParameter("MaxComputeResource", maxComputeResource);
            this.maxComputeResource = maxComputeResource;
            return this;
        }

        public Builder maxGpuQuantity(Integer maxGpuQuantity) {
            this.putQueryParameter("MaxGpuQuantity", maxGpuQuantity);
            this.maxGpuQuantity = maxGpuQuantity;
            return this;
        }

        public Builder minClusterCount(Integer minClusterCount) {
            this.putQueryParameter("MinClusterCount", minClusterCount);
            this.minClusterCount = minClusterCount;
            return this;
        }

        public Builder minComputeResource(String minComputeResource) {
            this.putQueryParameter("MinComputeResource", minComputeResource);
            this.minComputeResource = minComputeResource;
            return this;
        }

        public Builder minGpuQuantity(Integer minGpuQuantity) {
            this.putQueryParameter("MinGpuQuantity", minGpuQuantity);
            this.minGpuQuantity = minGpuQuantity;
            return this;
        }

        public Builder rayConfig(RayConfig rayConfig) {
            String rayConfigShrink = this.shrink((Object)rayConfig, "RayConfig", "json");
            this.putQueryParameter("RayConfig", rayConfigShrink);
            this.rayConfig = rayConfig;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder rules(List<Rules> rules) {
            String rulesShrink = this.shrink(rules, "Rules", "json");
            this.putQueryParameter("Rules", rulesShrink);
            this.rules = rules;
            return this;
        }

        public Builder specName(String specName) {
            this.putQueryParameter("SpecName", specName);
            this.specName = specName;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public Builder targetResourceGroupName(String targetResourceGroupName) {
            this.putQueryParameter("TargetResourceGroupName", targetResourceGroupName);
            this.targetResourceGroupName = targetResourceGroupName;
            return this;
        }

        public ModifyDBResourceGroupRequest build() {
            return new ModifyDBResourceGroupRequest(this);
        }
    }
}

