/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.adb20211201.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateApsWebhookRequest
extends Request {
    @Body
    @NameInMap(value="DBClusterId")
    @Validation(required=true)
    private String DBClusterId;
    @Body
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Body
    @NameInMap(value="Webhook")
    private List<Webhook> webhook;

    private UpdateApsWebhookRequest(Builder builder) {
        super((Request.Builder)builder);
        this.DBClusterId = builder.DBClusterId;
        this.regionId = builder.regionId;
        this.webhook = builder.webhook;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateApsWebhookRequest create() {
        return UpdateApsWebhookRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDBClusterId() {
        return this.DBClusterId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public List<Webhook> getWebhook() {
        return this.webhook;
    }

    public static class Webhook
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Name")
        private String name;
        @NameInMap(value="Url")
        private String url;
        @NameInMap(value="WebhookId")
        @Validation(required=true)
        private Long webhookId;
        @NameInMap(value="WebhookType")
        private String webhookType;

        private Webhook(Builder builder) {
            this.key = builder.key;
            this.name = builder.name;
            this.url = builder.url;
            this.webhookId = builder.webhookId;
            this.webhookType = builder.webhookType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Webhook create() {
            return Webhook.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public Long getWebhookId() {
            return this.webhookId;
        }

        public String getWebhookType() {
            return this.webhookType;
        }

        public static final class Builder {
            private String key;
            private String name;
            private String url;
            private Long webhookId;
            private String webhookType;

            private Builder() {
            }

            private Builder(Webhook model) {
                this.key = model.key;
                this.name = model.name;
                this.url = model.url;
                this.webhookId = model.webhookId;
                this.webhookType = model.webhookType;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder webhookId(Long webhookId) {
                this.webhookId = webhookId;
                return this;
            }

            public Builder webhookType(String webhookType) {
                this.webhookType = webhookType;
                return this;
            }

            public Webhook build() {
                return new Webhook(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateApsWebhookRequest, Builder> {
        private String DBClusterId;
        private String regionId;
        private List<Webhook> webhook;

        private Builder() {
        }

        private Builder(UpdateApsWebhookRequest request) {
            super((Request)request);
            this.DBClusterId = request.DBClusterId;
            this.regionId = request.regionId;
            this.webhook = request.webhook;
        }

        public Builder DBClusterId(String DBClusterId) {
            this.putBodyParameter("DBClusterId", DBClusterId);
            this.DBClusterId = DBClusterId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putBodyParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder webhook(List<Webhook> webhook) {
            String webhookShrink = this.shrink(webhook, "Webhook", "json");
            this.putBodyParameter("Webhook", webhookShrink);
            this.webhook = webhook;
            return this;
        }

        public UpdateApsWebhookRequest build() {
            return new UpdateApsWebhookRequest(this);
        }
    }
}

