/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactoryAPI;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.PullConsumer;
import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.impl.rocketmq.BatchConsumerImpl;
import com.aliyun.openservices.ons.api.impl.rocketmq.ConsumerImpl;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.rocketmq.OrderConsumerImpl;
import com.aliyun.openservices.ons.api.impl.rocketmq.OrderProducerImpl;
import com.aliyun.openservices.ons.api.impl.rocketmq.ProducerImpl;
import com.aliyun.openservices.ons.api.impl.rocketmq.PullConsumerImpl;
import com.aliyun.openservices.ons.api.impl.rocketmq.TransactionProducerImpl;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.DefaultConsumerRetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.DefaultProducerRetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import java.util.Properties;

public class ONSFactoryImpl
implements ONSFactoryAPI {
    @Override
    public Producer createProducer(Properties properties) {
        return this.createProducer(properties, new DefaultProducerRetryStrategy());
    }

    @Override
    public Producer createProducer(Properties properties, RetryStrategy retryStrategy) {
        return new ProducerImpl(ONSUtil.extractProperties(properties), retryStrategy);
    }

    @Override
    public Consumer createConsumer(Properties properties) {
        return this.createConsumer(properties, new DefaultConsumerRetryStrategy());
    }

    @Override
    public Consumer createConsumer(Properties properties, RetryStrategy retryStrategy) {
        return new ConsumerImpl(ONSUtil.extractProperties(properties), retryStrategy);
    }

    @Override
    public BatchConsumer createBatchConsumer(Properties properties) {
        return this.createBatchConsumer(properties, new DefaultConsumerRetryStrategy());
    }

    @Override
    public BatchConsumer createBatchConsumer(Properties properties, RetryStrategy retryStrategy) {
        return new BatchConsumerImpl(ONSUtil.extractProperties(properties), retryStrategy);
    }

    @Override
    public OrderProducer createOrderProducer(Properties properties) {
        return this.createOrderProducer(properties, new DefaultProducerRetryStrategy());
    }

    @Override
    public OrderProducer createOrderProducer(Properties properties, RetryStrategy retryStrategy) {
        return new OrderProducerImpl(ONSUtil.extractProperties(properties), retryStrategy);
    }

    @Override
    public OrderConsumer createOrderedConsumer(Properties properties) {
        return this.createOrderedConsumer(properties, new DefaultConsumerRetryStrategy());
    }

    @Override
    public OrderConsumer createOrderedConsumer(Properties properties, RetryStrategy retryStrategy) {
        return new OrderConsumerImpl(ONSUtil.extractProperties(properties), retryStrategy);
    }

    @Override
    public TransactionProducer createTransactionProducer(Properties properties, final LocalTransactionChecker checker, RetryStrategy retryStrategy) {
        return new TransactionProducerImpl(ONSUtil.extractProperties(properties), new TransactionCheckListener(){

            @Override
            public LocalTransactionState checkLocalTransactionState(MessageExt msg) {
                String msgId = msg.getProperty("UNIQ_KEY");
                Message message = ONSUtil.msgConvert(msg);
                message.setMsgID(msgId);
                TransactionStatus check = checker.check(message);
                if (TransactionStatus.CommitTransaction == check) {
                    return LocalTransactionState.COMMIT_MESSAGE;
                }
                if (TransactionStatus.RollbackTransaction == check) {
                    return LocalTransactionState.ROLLBACK_MESSAGE;
                }
                return LocalTransactionState.UNKNOW;
            }
        });
    }

    @Override
    public TransactionProducer createTransactionProducer(Properties properties, LocalTransactionChecker checker) {
        return this.createTransactionProducer(properties, checker, new DefaultProducerRetryStrategy());
    }

    @Override
    public PullConsumer createPullConsumer(Properties properties) {
        return new PullConsumerImpl(properties);
    }
}

