/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.opentelemetry.context;

import com.aliyun.openservices.shade.io.opentelemetry.context.Context;
import com.aliyun.openservices.shade.io.opentelemetry.context.ContextStorage;
import com.aliyun.openservices.shade.io.opentelemetry.context.Scope;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

enum ThreadLocalContextStorage implements ContextStorage
{
    INSTANCE;

    private static final Logger logger;
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE;

    @Override
    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set(toAttach);
        return () -> {
            if (this.current() != toAttach) {
                logger.log(Level.FINE, "Context in storage not the expected context, Scope.close was not called correctly");
            }
            THREAD_LOCAL_STORAGE.set(beforeAttach);
        };
    }

    @Override
    @Nullable
    public Context current() {
        return THREAD_LOCAL_STORAGE.get();
    }

    static {
        logger = Logger.getLogger(ThreadLocalContextStorage.class.getName());
        THREAD_LOCAL_STORAGE = new ThreadLocal();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }
}

