package com.alicloud.openservices.tablestore.model.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;

public class SearchRowIterator implements RowIterator {

    private SyncClientInterface client;
    private Iterator<Row> rowsIterator;
    private SearchRequest searchRequest;
    private SearchResponse searchResponse;

    public SearchRowIterator(SyncClientInterface syncClient, SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        this.client = syncClient;
        fetchData();
    }

    private void fetchData() {
        if (null != searchResponse) {
            if (null == searchResponse.getNextToken()) {
                return;
            } else {
                searchRequest.getSearchQuery().setToken(searchResponse.getNextToken());
            }
        }
        searchResponse = this.client.search(searchRequest);
        if (searchResponse.isAllSuccess()) {
            rowsIterator = searchResponse.getRows().iterator();
        } else {
            throw new RuntimeException("not all success");
        }
    }


    private boolean isBufferHasMoreData() {
        return rowsIterator.hasNext();
    }

    private Row getNextFromBuffer() {
        return rowsIterator.next();
    }

    @Override
    public boolean hasNext() {
        // has data in buffer
        if (isBufferHasMoreData()) {
            return true;
        }
        fetchData();
        return isBufferHasMoreData();
    }

    @Override
    public Row next() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        return getNextFromBuffer();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }

    @Override
    public long getTotalCount() {
        return searchResponse == null ? -1 : searchResponse.getTotalCount();
    }

}
