/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;

public class SwipeDismissTouchListener
implements View.OnTouchListener {
    public static final int MIN_VIEW_WIDTH = 2;
    public static final int A_HALF = 2;
    public static final int ONE_THIRD = 3;
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private View mView;
    private DismissCallbacks mCallbacks;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private Object mToken;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;
    private boolean mO;
    private boolean mCanFinish;

    public SwipeDismissTouchListener(View view, Object object, DismissCallbacks dismissCallbacks) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)view.getContext());
        this.mSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mAnimationTime = view.getContext().getResources().getInteger(0x10E0000);
        this.mView = view;
        this.mToken = object;
        this.mCallbacks = dismissCallbacks;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        motionEvent.offsetLocation(this.mTranslationX, 0.0f);
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mDownX = motionEvent.getRawX();
                this.mDownY = motionEvent.getRawY();
                if (this.mCallbacks.canDismiss(this.mToken)) {
                    this.mO = false;
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                return true;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                float f2 = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float f3 = this.mVelocityTracker.getXVelocity();
                float f4 = Math.abs(f3);
                float f5 = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean bl2 = false;
                boolean bl3 = false;
                if (Math.abs(f2) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    bl2 = true;
                    bl3 = f2 > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= f4 && f4 <= (float)this.mMaxFlingVelocity && f5 < f4 && this.mSwiping) {
                    bl2 = f3 < 0.0f == f2 < 0.0f;
                    boolean bl4 = bl3 = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (bl2) {
                    this.mView.animate().translationX(bl3 ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(50L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public final void onAnimationEnd(Animator animator) {
                            SwipeDismissTouchListener.this.a();
                        }
                    });
                } else if (this.mSwiping) {
                    this.mView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float f6 = motionEvent.getRawX() - this.mDownX;
                float f7 = motionEvent.getRawY() - this.mDownY;
                if (Math.abs(f6) > (float)this.mSlop && Math.abs(f7) < Math.abs(f6) / 2.0f) {
                    this.mSwiping = true;
                    this.mSwipingSlop = f6 > 0.0f ? this.mSlop : -this.mSlop;
                    this.mView.getParent().requestDisallowInterceptTouchEvent(true);
                    if (!this.mO) {
                        this.mO = true;
                        this.mCallbacks.onNotifySwipe();
                    }
                    if (Math.abs(f6) > (float)(this.mViewWidth / 3)) {
                        if (!this.mCanFinish) {
                            this.mCanFinish = true;
                            this.mCallbacks.onNotifySwipe();
                        }
                    } else {
                        this.mCanFinish = false;
                    }
                    MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mView.onTouchEvent(motionEvent2);
                    motionEvent2.recycle();
                }
                if (!this.mSwiping) break;
                this.mTranslationX = f6;
                this.mView.setTranslationX(f6 - (float)this.mSwipingSlop);
                this.mView.setAlpha(Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(f6) / (float)this.mViewWidth)));
                return true;
            }
        }
        return false;
    }

    private void a() {
        this.mCallbacks.onDismiss(this.mView, this.mToken);
        final ViewGroup.LayoutParams layoutParams = this.mView.getLayoutParams();
        final int n2 = this.mView.getHeight();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{n2, 1}).setDuration(this.mAnimationTime);
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public final void onAnimationEnd(Animator animator) {
                SwipeDismissTouchListener.this.mView.setAlpha(0.0f);
                SwipeDismissTouchListener.this.mView.setTranslationX(0.0f);
                layoutParams.height = n2;
                SwipeDismissTouchListener.this.mView.setLayoutParams(layoutParams);
            }
        });
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                layoutParams.height = (Integer)valueAnimator.getAnimatedValue();
                SwipeDismissTouchListener.this.mView.setLayoutParams(layoutParams);
            }
        });
        valueAnimator.start();
    }

    public static interface DismissCallbacks {
        public boolean canDismiss(Object var1);

        public void onDismiss(View var1, Object var2);

        public void onNotifySwipe();
    }
}

