/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.CircleOptions;
import com.amap.api.maps.model.LatLng;
import java.lang.ref.WeakReference;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Circle
extends BaseOverlay {
    private CircleOptions options;
    WeakReference<IGlOverlayLayer> a;

    public Circle(IGlOverlayLayer iGlOverlayLayer, CircleOptions circleOptions, String string2) {
        super(string2);
        this.a = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = circleOptions;
    }

    public final void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.a.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final String getId() {
        try {
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setCenter(LatLng latLng) {
        try {
            if (this.options != null) {
                this.options.center(latLng);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final LatLng getCenter() {
        try {
            if (this.options != null) {
                return this.options.getCenter();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setRadius(double d2) {
        try {
            if (this.options != null) {
                this.options.radius(d2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final double getRadius() {
        try {
            if (this.options != null) {
                return this.options.getRadius();
            }
            return 0.0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0;
        }
    }

    public final void setStrokeWidth(float f2) {
        try {
            if (this.options != null) {
                this.options.strokeWidth(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getStrokeWidth() {
        try {
            if (this.options != null) {
                return this.options.getStrokeWidth();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final void setStrokeColor(int n2) {
        try {
            if (this.options != null) {
                this.options.strokeColor(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getStrokeColor() {
        try {
            if (this.options != null) {
                return this.options.getStrokeColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setFillColor(int n2) {
        try {
            if (this.options != null) {
                this.options.fillColor(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getFillColor() {
        try {
            if (this.options != null) {
                return this.options.getFillColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setZIndex(float f2) {
        try {
            if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getZIndex() {
        try {
            if (this.options != null) {
                return this.options.getZIndex();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final void setVisible(boolean bl2) {
        try {
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isVisible() {
        try {
            if (this.options != null) {
                return this.options.isVisible();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Circle)) {
            return false;
        }
        try {
            return super.equals(object) || ((Circle)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final int hashCode() {
        try {
            return super.hashCode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final boolean contains(LatLng latLng) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.a.get();
            if (iGlOverlayLayer != null) {
                return iGlOverlayLayer.IsCircleContainPoint(this.options, latLng);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHoleOptions(List<BaseHoleOptions> list) {
        try {
            if (list != null) {
                List<BaseHoleOptions> list2 = list;
                synchronized (list2) {
                    this.options.getHoleOptions().clear();
                    this.options.addHoles(list);
                    this.a();
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final List<BaseHoleOptions> getHoleOptions() {
        try {
            if (this.options != null) {
                return this.options.getHoleOptions();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setStrokeDottedLineType(int n2) {
        try {
            if (this.options != null) {
                this.options.setStrokeDottedLineType(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getStrokeDottedLineType() {
        try {
            if (this.options != null) {
                return this.options.getStrokeDottedLineType();
            }
            return -1;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.a.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

