/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.MultiPointItem;
import com.amap.api.maps.model.MultiPointOverlayOptions;
import java.lang.ref.WeakReference;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPointOverlay
extends BaseOverlay {
    private MultiPointOverlayOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public MultiPointOverlay(IGlOverlayLayer iGlOverlayLayer, MultiPointOverlayOptions multiPointOverlayOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = multiPointOverlayOptions;
    }

    public void setItems(List<MultiPointItem> list) {
        if (this.options != null) {
            this.options.setMultiPointItems(list);
            this.a();
        }
    }

    public List<MultiPointItem> getItems() {
        if (this.options != null) {
            return this.options.getMultiPointItems();
        }
        return null;
    }

    public void setAnchor(float f2, float f3) {
        if (this.options != null) {
            this.options.anchor(f2, f3);
            this.a();
        }
    }

    public void setEnable(boolean bl2) {
        if (this.options != null) {
            this.options.setEnable(bl2);
            this.a();
        }
    }

    public void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void destroy() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void a() {
        IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
            iGlOverlayLayer.updateOption(this.overlayName, this.options);
        }
    }
}

