/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.NavigateArrowOptions;
import java.lang.ref.WeakReference;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigateArrow
extends BaseOverlay {
    private NavigateArrowOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public NavigateArrow(IGlOverlayLayer iGlOverlayLayer, NavigateArrowOptions navigateArrowOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = navigateArrowOptions;
    }

    public void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public String getId() {
        try {
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setPoints(List<LatLng> list) {
        try {
            if (this.options != null) {
                this.options.setPoints(list);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public List<LatLng> getPoints() {
        try {
            if (this.options != null) {
                return this.options.getPoints();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setWidth(float f2) {
        try {
            if (this.options != null) {
                this.options.width(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public float getWidth() {
        try {
            if (this.options != null) {
                return this.options.getWidth();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setTopColor(int n2) {
        try {
            if (this.options != null) {
                this.options.topColor(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public int getTopColor() {
        try {
            if (this.options != null) {
                return this.options.getTopColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setSideColor(int n2) {
        try {
            if (this.options != null) {
                this.options.sideColor(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Deprecated
    public int getSideColor() {
        try {
            if (this.options != null) {
                return this.options.getSideColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setZIndex(float f2) {
        try {
            if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public float getZIndex() {
        try {
            if (this.options != null) {
                return this.options.getZIndex();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean isVisible() {
        try {
            if (this.options != null) {
                return this.options.isVisible();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void set3DModel(boolean bl2) {
        try {
            if (this.options != null) {
                this.options.set3DModel(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean is3DModel() {
        try {
            if (this.options != null) {
                return this.options.is3DModel();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NavigateArrow)) {
            return false;
        }
        try {
            return super.equals(object) || ((NavigateArrow)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        try {
            return super.hashCode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    private void a() {
        IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
            iGlOverlayLayer.updateOption(this.overlayName, this.options);
        }
    }
}

