/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.graphics.Point;
import com.amap.api.mapcore.util.dl;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.api.mapcore.IGLMapEngine;
import com.autonavi.amap.api.mapcore.IGLMapState;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.interfaces.IMapConfig;

public abstract class AbstractCameraUpdateMessage {
    public Type nowType = Type.none;
    public float xPixel;
    public float yPixel;
    public float amount;
    public CameraPosition cameraPosition;
    public LatLngBounds bounds;
    public Point focus = null;
    public float zoom = Float.NaN;
    public float tilt = Float.NaN;
    public float bearing = Float.NaN;
    public DPoint geoPoint;
    public boolean isUseAnchor = false;
    public int anchorX;
    public int anchorY;
    public boolean isChangeFinished;
    public int paddingLeft;
    public int paddingRight;
    public int paddingTop;
    public int paddingBottom;
    public AMap.CancelableCallback mCallback;
    public long mDuration = 250L;
    public IMapConfig mapConfig;
    public float maxZoomLevel = 0.0f;
    public float minZoomLevel = 0.0f;
    public float curZoolScale = 0.0f;
    public int width;
    public int height;

    public abstract void runCameraUpdate(IGLMapState var1);

    protected void normalChange(IGLMapState iGLMapState) {
        this.zoom = Float.isNaN(this.zoom) ? iGLMapState.getMapZoomer() : this.zoom;
        this.bearing = Float.isNaN(this.bearing) ? iGLMapState.getMapAngle() : this.bearing;
        this.tilt = Float.isNaN(this.tilt) ? iGLMapState.getCameraDegree() : this.tilt;
        this.zoom = dl.a(this.mapConfig, this.zoom);
        this.tilt = dl.a(this.mapConfig, this.tilt, this.zoom);
        this.bearing = (float)(((double)this.bearing % 360.0 + 360.0) % 360.0);
        if (this.focus != null && this.geoPoint == null) {
            Object object = this.getAnchorGeoPoint(iGLMapState, this.focus.x, this.focus.y);
            object = new DPoint(object.x, object.y);
            this.geoPoint = object;
        }
        if (!Float.isNaN(this.zoom)) {
            iGLMapState.setMapZoomer(this.zoom);
        }
        if (!Float.isNaN(this.bearing)) {
            iGLMapState.setMapAngle(this.bearing);
        }
        if (!Float.isNaN(this.tilt)) {
            iGLMapState.setCameraDegree(this.tilt);
        }
        if (this.focus != null) {
            this.changeCenterByAnchor(iGLMapState, this.geoPoint, this.focus.x, this.focus.y);
            return;
        }
        if (this.geoPoint != null && (this.geoPoint.x != 0.0 || this.geoPoint.y != 0.0)) {
            iGLMapState.setMapGeoCenter(this.geoPoint.x, this.geoPoint.y);
        }
    }

    protected void changeCenterByAnchor(IGLMapState iGLMapState, DPoint dPoint) {
        this.changeCenterByAnchor(iGLMapState, dPoint, this.anchorX, this.anchorY);
    }

    protected void changeCenterByAnchor(IGLMapState iGLMapState, DPoint dPoint, int n2, int n3) {
        iGLMapState.recalculate();
        Point point = this.getAnchorGeoPoint(iGLMapState, n2, n3);
        DPoint dPoint2 = iGLMapState.getMapGeoCenter();
        iGLMapState.setMapGeoCenter(dPoint2.x + dPoint.x - (double)point.x, dPoint2.y + dPoint.y - (double)point.y);
    }

    protected Point getAnchorGeoPoint(IGLMapState iGLMapState, int n2, int n3) {
        Point point = new Point();
        iGLMapState.screenToP20Point(n2, n3, point);
        return point;
    }

    public abstract void mergeCameraUpdateDelegate(AbstractCameraUpdateMessage var1);

    public void generateMapAnimation(IGLMapEngine iGLMapEngine) {
        IGLMapState iGLMapState = iGLMapEngine.getNewMapState(1);
        this.runCameraUpdate(iGLMapState);
        DPoint dPoint = iGLMapState.getMapGeoCenter();
        iGLMapEngine.addGroupAnimation(1, (int)this.mDuration, iGLMapState.getMapZoomer(), (int)iGLMapState.getMapAngle(), (int)iGLMapState.getCameraDegree(), (int)dPoint.x, (int)dPoint.y, this.mCallback);
        iGLMapState.recycle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        none,
        zoomIn,
        changeCenter,
        changeTilt,
        changeBearing,
        changeBearingGeoCenter,
        changeGeoCenterZoom,
        zoomOut,
        zoomTo,
        zoomBy,
        scrollBy,
        newCameraPosition,
        newLatLngBounds,
        newLatLngBoundsWithSize,
        changeGeoCenterZoomTiltBearing;

    }
}

