/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glanimation;

import android.graphics.Point;
import android.os.SystemClock;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.base.ae.gmap.GLMapState;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimation;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimationParam1V;

public class AdglMapAnimPivotZoom
extends AbstractAdglAnimation {
    private boolean hasCheckParams;
    private float mapLevelTo;
    private int beginCenterGeoX;
    private int beginCenterGeoY;
    private int pivotGeoX;
    private int pivotGeoY;
    private boolean zoomCenter;
    private float winPivotX;
    private float winPivotY;
    AbstractAdglAnimationParam1V zoomParam = null;

    public void reset() {
        this.isOver = false;
        this.hasCheckParams = false;
        this.zoomCenter = true;
        this.mapLevelTo = 0.0f;
        this.beginCenterGeoX = 0;
        this.beginCenterGeoY = 0;
        this.pivotGeoX = 0;
        this.pivotGeoY = 0;
        this.winPivotX = 0.0f;
        this.winPivotY = 0.0f;
        if (this.zoomParam != null) {
            this.zoomParam.reset();
        }
    }

    public void commitAnimation(Object object) {
        this.isOver = true;
        this.hasCheckParams = false;
        if ((object = (GLMapState)object) == null) {
            return;
        }
        float f2 = ((GLMapState)object).getMapZoomer();
        if ((double)Math.abs(this.mapLevelTo - f2) < 1.0E-6) {
            this.isOver = true;
            this.hasCheckParams = true;
            return;
        }
        this.zoomParam.setFromValue(f2);
        this.zoomParam.setToValue(this.mapLevelTo);
        if (!this.zoomCenter) {
            IPoint iPoint = IPoint.obtain();
            ((GLMapState)object).getMapGeoCenter(iPoint);
            this.beginCenterGeoX = iPoint.x;
            this.beginCenterGeoY = iPoint.y;
            IPoint iPoint2 = IPoint.obtain();
            ((GLMapState)object).screenToP20Point((int)this.winPivotX, (int)this.winPivotY, iPoint2);
            this.pivotGeoX = iPoint2.x;
            this.pivotGeoY = iPoint2.y;
            iPoint.recycle();
            iPoint2.recycle();
        }
        this.hasCheckParams = true;
        this.isOver = false;
        this.startTime = SystemClock.uptimeMillis();
    }

    public AdglMapAnimPivotZoom(int n2) {
        this.reset();
        this.duration = n2;
    }

    public void setToMapZoomAndPivot(float f2, int n2, Point point) {
        this.zoomParam = new AbstractAdglAnimationParam1V();
        this.zoomParam.setInterpolatorType(n2, 1.0f);
        if (f2 > 20.0f) {
            f2 = 20.0f;
        }
        if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        this.mapLevelTo = f2;
        if (point != null) {
            this.winPivotX = point.x;
            this.winPivotY = point.y;
            this.zoomCenter = false;
        }
    }

    public void doAnimation(Object object) {
        float f2;
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this.hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this.isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this.offsetTime = l2 - this.startTime;
        float f3 = (float)this.offsetTime / (float)this.duration;
        if (f2 > 1.0f) {
            f3 = 1.0f;
            this.isOver = true;
        }
        if (f3 >= 0.0f && f3 <= 1.0f) {
            float f4;
            this.zoomParam.setNormalizedTime(f3);
            f3 = this.zoomParam.getCurValue();
            if (f4 > 20.0f) {
                f3 = 20.0f;
                this.isOver = true;
            }
            if (f3 < 3.0f) {
                f3 = 3.0f;
                this.isOver = true;
            }
            if (!this.zoomCenter) {
                float f5 = f3 - this.zoomParam.getFromValue();
                f5 = (float)Math.pow(2.0, f5);
                int n2 = (int)((float)(this.pivotGeoX - this.beginCenterGeoX) * (1.0f - 1.0f / f5));
                int n3 = (int)((float)(this.pivotGeoY - this.beginCenterGeoY) * (1.0f - 1.0f / f5));
                gLMapState.setMapGeoCenter(this.beginCenterGeoX + n2, this.beginCenterGeoY + n3);
            }
            gLMapState.setMapZoomer(f3);
        }
    }
}

