/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.servlet.verifiers;

import com.amazon.ask.model.Request;
import com.amazon.ask.servlet.verifiers.AlexaHttpRequest;
import com.amazon.ask.servlet.verifiers.SkillServletVerifier;
import com.amazon.ask.util.ValidationUtils;
import java.util.concurrent.TimeUnit;

public class SkillRequestTimestampVerifier
implements SkillServletVerifier {
    private final long toleranceInMilliseconds;

    public SkillRequestTimestampVerifier(long toleranceInMilliseconds) {
        if (toleranceInMilliseconds > 3600000L) {
            throw new IllegalArgumentException(String.format("Provided tolerance value %s exceeds the maximum allowed %s", toleranceInMilliseconds, 3600000L));
        }
        if (toleranceInMilliseconds < 0L) {
            throw new IllegalArgumentException("A negative tolerance is not supported");
        }
        this.toleranceInMilliseconds = toleranceInMilliseconds;
    }

    public SkillRequestTimestampVerifier(long tolerance, TimeUnit timeUnit) {
        this(((TimeUnit)((Object)ValidationUtils.assertNotNull((Object)((Object)timeUnit), (String)"timeUnit"))).toMillis(tolerance));
    }

    @Override
    public void verify(AlexaHttpRequest alexaHttpRequest) {
        boolean withinTolerance;
        if (alexaHttpRequest.getDeserializedRequestEnvelope() == null) {
            throw new SecurityException("Incoming request did not contain a request envelope");
        }
        Request request = alexaHttpRequest.getDeserializedRequestEnvelope().getRequest();
        if (request == null || request.getTimestamp() == null) {
            throw new SecurityException("Incoming request was null or did not contain a timestamp to evaluate");
        }
        long requestTimestamp = request.getTimestamp().toInstant().toEpochMilli();
        long delta = Math.abs(System.currentTimeMillis() - requestTimestamp);
        boolean bl = withinTolerance = delta <= this.toleranceInMilliseconds;
        if (!withinTolerance) {
            throw new SecurityException(String.format("Request with id %s and timestamp %s failed timestamp validation with a delta of %s", request.getRequestId(), requestTimestamp, delta));
        }
    }
}

