/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.neptune.gremlin.driver.example;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.SigV4WebSocketChannelizer;

public final class NeptuneGremlinSigV4Example {
    private static final String ENDPOINT = "endpoint";
    private static final String PORT = "port";
    private static final String SSL = "ssl";
    private static final String SAMPLE_QUERY = "g.V().count()";

    private NeptuneGremlinSigV4Example() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = NeptuneGremlinSigV4Example.setupCliOptions();
        CommandLine cli = NeptuneGremlinSigV4Example.parseArgs(args, options);
        Cluster.Builder builder = Cluster.build();
        builder.addContactPoint(cli.getOptionValue(ENDPOINT));
        builder.port(Integer.parseInt(cli.getOptionValue(PORT)));
        builder.channelizer(SigV4WebSocketChannelizer.class);
        builder.enableSsl(Boolean.parseBoolean(cli.getOptionValue(SSL, "false")));
        try (Cluster cluster = builder.create();){
            Client client = cluster.connect();
            ResultSet rs = client.submit(SAMPLE_QUERY);
            for (Result r : rs) {
                System.out.println(r);
            }
        }
    }

    private static CommandLine parseArgs(String[] args, Options options) {
        BasicParser parser = new BasicParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            formatter.printHelp(NeptuneGremlinSigV4Example.class.getSimpleName(), options);
            throw new RuntimeException("Invalid command line args");
        }
    }

    private static Options setupCliOptions() {
        Options options = new Options();
        Option endpoint = new Option("e", ENDPOINT, true, "The db cluster/instance endpoint");
        endpoint.setRequired(true);
        options.addOption(endpoint);
        Option port = new Option("p", PORT, true, "The db cluster/instance port");
        port.setRequired(true);
        options.addOption(port);
        Option ssl = new Option("s", SSL, true, "Whether to enable ssl on the connection");
        ssl.setRequired(false);
        ssl.setType(Boolean.class);
        options.addOption(ssl);
        return options;
    }
}

