/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import com.amazon.neptune.gremlin.driver.sigv4.AwsSigV4ClientHandshaker;
import com.amazon.neptune.gremlin.driver.sigv4.ChainedSigV4PropertiesProvider;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import java.util.concurrent.TimeoutException;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketClientHandler;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinResponseDecoder;

public class SigV4WebSocketChannelizer
extends Channelizer.AbstractChannelizer {
    private static final String WEB_SOCKET = "ws";
    private static final String WEB_SOCKET_SECURE = "wss";
    private static final String HTTP_CODEC = "http-codec";
    private static final String AGGREGATOR = "aggregator";
    private static final String WEB_SOCKET_HANDLER = "ws-handler";
    private static final String GREMLIN_ENCODER = "gremlin-encoder";
    private static final String GRELIN_DECODER = "gremlin-decoder";
    public static final String WEBSOCKET_COMPRESSION_HANDLER = "web-socket-compression-handler";
    private WebSocketClientHandler handler;
    private WebSocketGremlinRequestEncoder webSocketGremlinRequestEncoder;
    private WebSocketGremlinResponseDecoder webSocketGremlinResponseDecoder;

    public void init(Connection connection) {
        super.init(connection);
        this.webSocketGremlinRequestEncoder = new WebSocketGremlinRequestEncoder(true, this.cluster.getSerializer());
        this.webSocketGremlinResponseDecoder = new WebSocketGremlinResponseDecoder(this.cluster.getSerializer());
    }

    public boolean supportsKeepAlive() {
        return true;
    }

    public Object createKeepAliveMessage() {
        return new PingWebSocketFrame();
    }

    public void close(Channel channel) {
        if (channel.isOpen()) {
            channel.writeAndFlush((Object)new CloseWebSocketFrame());
        }
    }

    public boolean supportsSsl() {
        String scheme = this.connection.getUri().getScheme();
        return WEB_SOCKET_SECURE.equalsIgnoreCase(scheme);
    }

    public void configure(ChannelPipeline pipeline) {
        String scheme = this.connection.getUri().getScheme();
        if (!WEB_SOCKET.equalsIgnoreCase(scheme) && !WEB_SOCKET_SECURE.equalsIgnoreCase(scheme)) {
            throw new IllegalStateException(String.format("Unsupported scheme (only %s: or %s: supported): %s", WEB_SOCKET, WEB_SOCKET_SECURE, scheme));
        }
        if (!this.supportsSsl() && WEB_SOCKET_SECURE.equalsIgnoreCase(scheme)) {
            throw new IllegalStateException(String.format("To use %s scheme ensure that enableSsl is set to true in configuration", WEB_SOCKET_SECURE));
        }
        int maxContentLength = this.cluster.connectionPoolSettings().maxContentLength;
        this.handler = this.createHandler();
        pipeline.addLast(HTTP_CODEC, (ChannelHandler)new HttpClientCodec());
        pipeline.addLast(AGGREGATOR, (ChannelHandler)new HttpObjectAggregator(maxContentLength));
        pipeline.addLast(WEBSOCKET_COMPRESSION_HANDLER, (ChannelHandler)WebSocketClientCompressionHandler.INSTANCE);
        pipeline.addLast(WEB_SOCKET_HANDLER, (ChannelHandler)this.handler);
        pipeline.addLast(GREMLIN_ENCODER, (ChannelHandler)this.webSocketGremlinRequestEncoder);
        pipeline.addLast(GRELIN_DECODER, (ChannelHandler)this.webSocketGremlinResponseDecoder);
    }

    public void connected() {
        try {
            this.handler.handshakeFuture().sync();
        }
        catch (Exception ex) {
            String errMsg = ex instanceof TimeoutException ? "Timed out while waiting to complete the connection setup. Consider increasing the WebSocket handshake timeout duration." : "Could not complete connection setup to the server. Ensure that SSL is correctly configured at both the client and the server. Ensure that client WebSocket handshake protocol matches the server. Ensure that the server is still reachable.";
            throw new ConnectionException(this.connection.getUri(), errMsg, (Throwable)ex);
        }
    }

    protected AWSCredentialsProvider getCredentialsProvider() {
        return new DefaultAWSCredentialsProviderChain();
    }

    private WebSocketClientHandler createHandler() {
        AwsSigV4ClientHandshaker handshaker = new AwsSigV4ClientHandshaker(this.connection.getUri(), WebSocketVersion.V13, null, true, (HttpHeaders)EmptyHttpHeaders.INSTANCE, this.cluster.getMaxContentLength(), new ChainedSigV4PropertiesProvider(), this.getCredentialsProvider());
        return new WebSocketClientHandler((WebSocketClientHandshaker)handshaker, this.cluster.getConnectionSetupTimeout());
    }
}

